package provide EUVSim 1.0

proc TotHe { BegX dX BegY dY Grid nGrid gInfo  } {
   global euvANS PI

   upvar $Grid HdM
   upvar $nGrid nHdM
   upvar $gInfo gHDM

   set xLen $gHDM(4)

   set nX [expr int($dX * $xLen / 360.0)]
   set nS [expr $xLen / $nX]

   TUgridInfo 0 gHDM rC $BegX $BegY

   set IncX [expr ($gHDM(1) - $gHDM(0)) / double($gHDM(4))] 
   set IncY [expr ($gHDM(3) - $gHDM(2)) / double($gHDM(5))]

   set aY $BegY
   set rN $rC(2)
   while { $aY < $gHDM(3) } {
      set Y1 $aY
      set Y2 [expr $Y1 + $IncY]
      set Area [expr $PI * ($Y2 * $Y2 - $Y1 * $Y1)]
      for { set sN 0 } { $sN < $nS } { incr sN } {
         set Sum 0.0
         set cO [expr $nX * $sN]
         for { set I 0 } { $I < $nX } { incr I } {
             set gN [expr $rN * $xLen + ($cO + $I) % $xLen]  
#            if { $nHdM($gN) > 0.0 } {set Sum [expr $Sum + pow(10.0, $HdM($gN))]}
             if { $nHdM($gN) > 0.0 } {set Sum [expr $Sum + $HdM($gN)]}
         }
      }
      set aY [expr $aY + $IncY]
      incr rN
   }
}
