package provide EUVSim 1.0

proc ReadEUVInv { File xX yY vV gInfo AnC } {
   global PI

   upvar $xX X
   upvar $yY Y
   upvar $vV D
   upvar $gInfo gI
   upvar $AnC aC

   set AnCIndx ""

   if [catch {open $File r} fd] {
      puts stderr "UNABLE TO OPEN SIM FILE: $File"
      return
   }

#  READ in the saved values 
#  REMEMBER!!!
#  NEED to update the option box labels to match the options read in.

   set I 0
   set GoOn 1
   while { $GoOn } { 
      gets $fd line
      set sLine [split $line ':']
      set FielD [string trim [lindex $sLine 0 ]]
      if [string match XSTART $FielD] {
         set gI(0) [string trim [lindex $sLine 1]]
         set GoOn 0
      } else { 
        lappend AnCIndx $FielD
        set aC($FielD) [string trim [lindex $sLine 1]] 
      }
      incr I
   }
   if ![info exists aC(FORMAT)] { set aC(FORMAT) PT }

   set I 1
   while { $I < 17 } { 
      gets $fd line
      set sLine [split $line ':']
      set FielD [string trim [lindex $sLine 0 ]]
      set gI($I) [string trim [lindex $sLine 1]]
      if [string match DO $FielD] { 
         set nE [llength $sLine]
         for { set J 2 } { $J < $nE } { incr J } { 
             append gI($I) :[lindex $sLine $J]
         }
      }
      incr I
   }

   set I 0
   if [string match PT $aC(FORMAT)] {
      while { [gets $fd line] > 0 } {
         scan $line "%f %f %f %f" X($I) Y($I) D($I) T
         if { $X($I) < 0.0 } {
            set X($I) [expr $PI + $X($I)]
         } else { set X($I) [expr $X($I) - $PI] }
         incr I
      }
   } else {
      while { [gets $fd line] > 0 } {
         scan $line "%f %f %f %f" X($I) Y($I) D($I) T
         incr I
      }
   }

   close $fd
   return $AnCIndx
}
