package provide EUVSim 1.0

#  THIS procedure checks the times of the EUV data read in from the
#    three image heads and makes sure that each comes from the same 
#    image, that is we haven't lost data from one of the heads and are
#    now out of sync in our march through the data file.  If this 
#    happens then we need to resync things.  
#
#  The three heads start accumulating data 1 spin minutes apart so that
#    head 1 should start about 2 minutes ahead of head 0 and head 2
#    about 4 minutes ahead of head 0.

proc ReSync { SetUpInfo } {
   global euvANS ExDa

   upvar $SetUpInfo sI

   set Ver 0
   set N 0


   set Sync 0
   set Synced 0

   for { set I 0 } { $I < 3 } { incr I } {
      set Yr($I) [lindex $euvANS(TmH$I) 0]
      set Dy($I) [lindex $euvANS(TmH$I) 1]
      set Sc($I) [expr int([lindex $euvANS(TmH$I) 2] / 1000) ]
   }

   while { !$Sync } { 

#  GET the times from all heads into seconds starting from a common year.

      set MinYr $Yr([TUdataMxMn Yr 3 <])
      set dY [TUyearLeap $MinYr]

      for { set I 0 } { $I < 3 } { incr I } {
         set Tm($I) [expr $dY * ($Yr($I) - $MinYr) + $Dy($I) * 86400 + $Sc($I)]
      }

      set dT10 [expr $Tm(1) - $Tm(0)]
      set dT21 [expr $Tm(2) - $Tm(1)]

# CHECK for sync. 

      if { ($dT10 > 0) && ($dT10 <= 180) } { 
         if { ($dT21 > 0) && ($dT21 <= 180) } { 
            set Sync 1
         }
      }

# IF we are out of sync what we what to do is to sync to the head which
#   has the most advanced time.

      if !$Sync {
         set Synced 1
         set SyncTo [TUdataMxMn Tm 3 >]
         set dT [expr $SyncTo * 3] 
         set Y $Yr($SyncTo)
         set D $Dy($SyncTo)
         set H [expr int($Sc($SyncTo) / 3600) ]
         set M [expr int(($Sc($SyncTo) % 3600) / 60) ]
         set S [expr int($Sc($SyncTo) % 60)]

         incr M -$dT
         if { $M < 0 } { incr M 60 ; incr H -1 }
         if { $H < 0 } { incr H 24 ; incr D -1 }
         if { $D < 1  } {
            incr Y -1
            set D [TUyearLeap $Y]
         }

         for { set I 0 ; set J 0 } { $I < 3 } { incr I ; incr J 4 } {
            ToThisTime $sI($J) $Ver $Y $D $H $M $S
            ReadUDF $sI($J) $Ver $N 0 0 0
            set Yr($I) $ExDa($N,BYR)
            set Dy($I) $ExDa($N,BDY)
            set Sc($I) [expr int($ExDa($N,BMSEC) / 1000) ]
            set T$I [TUtimeFmt 0 $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC)]
         }
      }
   }

   return $Synced
}
