# first we load in the standard vtk packages into tcl

package require vtk
package require vtkinteraction
package require vtktesting

# MAKE sure that all of the sources are identified to the program
 
source [ file join $env(TCLTOOLS_HOME) TclToolInits.tcl ]
TclToolInits GPH GUI PLT UTILS

lappend auto_path [file join $env(TCLTOOLS_HOME) TclEUVSim]
package require EUVSim
package require EUVSim_C

set dFile 2001146001158.sim
set Nt(0) 5.0
set Nt(1) 2.0
set Nt(2) 1.0

GraphicsOn VTK ETones
colorLUT SetTableRange 0.0 3.6

# 
# We create a 100 by 100 point plane to sample 
#
vtkPlaneSource plane
    plane SetXResolution 99
    plane SetYResolution 99

#
# We transform the plane by a factor of 10 on X and Y
#

vtkTransform transform
   transform Scale 10 10 1

vtkTransformPolyDataFilter transF
   transF SetInput [plane GetOutput]
   transF SetTransform transform

#
# Compute Bessel function and derivatives. We'll use a programmable filter
# for this. Not the unusual GetInput() & GetOutput() methods.
#

proc PThis { nT } {

#  upvar $D Dr
#  upvar $X Xr
#  upvar $Y Yr
#  upvar $gI gIr
   upvar $nT NT

puts stderr "$NT(0)"
   for { set I 0 } { $I < 3 } { incr I } { set Loc($I) $NT($I) }
   set pFI HeDen
   vtkProgrammableFilter HeDenF
      HeDenF SetInput [transF GetOutput]
#     HeDenF SetExecuteMethod "$pFI HeDenF NT Xr Yr Dr gIr"
      HeDenF SetExecuteMethod "$pFI HeDenF Loc"
}

#proc HeDen { pF NT Xp Yp Dp gIp }

proc HeDen { pF NT } {

#  upvar $Xp X
#  upvar $Yp Y
#  upvar $Dp D
#  upvar $gIp gI
   upvar $NT Ts

   puts stderr $Ts(0)
#  puts stderr $gI(0)
   exit

   set nP [expr $gI(4) * $gI(5)]
   set gI(10) NEW:ADD:END
   set gI(4) 100
   set gI(5) 100

   set sI(0) 1 ; set sI(1) 5 ; set sI(2) 4
   set sI(3) 2 ; set sI(4) 1 ; set sI(5) 0
   set sI(6) 0 ; set sI(7) 0 ; set sI(8) -2

   set sOp 1

   TUdataGrid $nP 1 X X 1 Y Y D GriD gNorM gI
   TUgridFill2D GriD gI "" sI
#  TUgridSmooth 2DFILTER GriD gI sOp

   set input [$pF GetPolyDataInput]
   set numPts [$input GetNumberOfPoints]
   vtkPoints newPts
   vtkFloatArray HeD

   for {set R 0} {$R < 100} {incr R} {
      for {set C 0} {$C < 100} {incr C} {
         TUgridInfo 1 gI rV $C $R
         TUgridInfo 20 gI XY $rV(0)
         set Gx [expr $XY(3) * cos($XY(2))]
         set Gy [expr $XY(3) * sin($XY(2))]
         if { $GriD($rV(0)) > 0.0 } {
            set Gv [expr log10($GriD($rV(0)))]
         } else { set Gv .1 }
         newPts InsertPoint $rV(0) $Gx $Gy $Gv
         eval HeD InsertValue $rV(0) $Gv
       }
    }

    [$pF GetPolyDataOutput] CopyStructure $input
    [$pF GetPolyDataOutput] SetPoints newPts
    [[$pF GetPolyDataOutput] GetPointData] SetScalars HeD

    newPts Delete;
    HeD Delete
}

#
# The SetExecuteMethod takes a Tcl proc as an argument
# In here is where all the processing is done.
#

#
# We warp the plane based on the scalar values calculated above
#

set aF [ReadEUVInv $dFile  X Y D gI AnC]
# PThis X Y D gI Nt
puts stderr $aF
PThis Nt

vtkWarpScalar warp
    warp SetInput [HeDenF GetPolyDataOutput]
#   warp SetInput [map1 GetPolyDataOutput]
    warp XYPlaneOn
    warp SetScaleFactor 0.5

#
# We create a mapper and actor as usual. In the case we adjust the 
# scalar range of the mapper to match that of the computed scalars
#

vtkPolyDataMapper mapper
    mapper SetInput [warp GetPolyDataOutput]
    eval mapper SetScalarRange [[HeDenF GetPolyDataOutput] GetScalarRange]

vtkActor carpet
    carpet SetMapper mapper

#
# Create the RenderWindow, Renderer
#
vtkRenderer ren1
vtkRenderWindow renWin
    renWin AddRenderer ren1
vtkRenderWindowInteractor iren
    iren SetRenderWindow renWin

ren1 AddActor carpet
renWin SetSize 500 500

# render the image
#
iren AddObserver UserEvent {wm deiconify .vtkInteract}
[ren1 GetActiveCamera] Zoom 1.5
renWin Render

# prevent the tk window from showing up then start the event loop
wm withdraw .

