package provide EUVSim 1.0

# THIS procedure does all of the premenu initializations.  Most of these
#    are variables that need to be set for the menus is not already set
#    by reading in a pre-defined menu.  Some or all of these varaibles
#    may be redefined in the menus.  The procedure PostMenuSetup takes
#    care of any varaibles which might need to be redefined due to
#    changes. 

proc PreMenuSetup {  } {

   global euvANS dCoef Re

# MIGHT as well set the Earth's radius in km here.

   set Re 6370.0

   set euvANS(SolGrid)    PT
   set euvANS(xgRes)     .03
   set euvANS(ygRes)     .1

   set euvANS(begYr)    2001
   set euvANS(begDy)      99
   set euvANS(begHr)       2
   set euvANS(begMn)      32
   set euvANS(begSc)       0
   set euvANS(endYr)    2001
   set euvANS(endDy)      99
   set euvANS(endHr)      18
   set euvANS(endMn)      46
   set euvANS(endSc)       0

   set euvANS(bkStat)      0
   set euvANS(bkLoc)       0
   set euvANS(bkDeg)       0.0
   set euvANS(doPrnt)      1
   set euvANS(mXBeg)     -36.0
   set euvANS(mYBeg)     -36.0
   set euvANS(mXEnd)      36.0
   set euvANS(mYEnd)      36.0
   set euvANS(pXGrids)   100
   set euvANS(pYGrids)   200 
   set euvANS(lowestR)     1.1
   set euvANS(lowestI) -1.0e30
   set euvANS(bkSig)       0.0
   set euvANS(deSpeck)     0
   set euvANS(speckN)      0
   set euvANS(spMin)     0.0
   set euvANS(spRep)       1
   set euvANS(pcdeSpeck)    0
   set euvANS(pcspeckN)     0
   set euvANS(pcspMin)    0.0
   set euvANS(pcspRep)      1
   set euvANS(sdeSpeck)    0
   set euvANS(sspeckN)     0
   set euvANS(sspMin)    0.0
   set euvANS(sspRep)      1
   set euvANS(hotSpot)     0
   set euvANS(hsBase)    100.0
   set euvANS(hsOver)      3.0
   set euvANS(zdeSpeck)    0
   set euvANS(zspeckN)     0
   set euvANS(zspMin)    0.0
   set euvANS(zspRep)      1
   set euvANS(srNoise)     0
   set euvANS(srGrids)     0

# pState gives what actions need to be performed in PlotAct at the beginning
#   and at the end of an inversion.
#
#  START: determine if there are non-postscript plots in which case we need
#     to pause after each inversion
#  SINGLE: Need to pause after an inversion
#  AUTO: Just crank out the inversions until time is exceeded
#  NEXT: Activate the next button for single plots
#  SDONE:  Single Inversion is complete
#  ADONE:  Auto Inversion is complete

   set euvANS(pState)   START
   set euvANS(iCnT)        0

   set euvANS(Var)        0.0
   set euvANS(TotP)      -1
   set euvANS(shaDow)     1
   set euvANS(XGap)       2
   set euvANS(YGap)       5

# ID's
#
#   mi:  Measured Image
#   si:  Simulated Image
#   ls:  L-Shell
#   ra:  Ratio
#   eq:  SM Measured Image
#   ps:  Plasmasphere 
#   rg:  Radial Gradient
#   ag:  Azimuthal Gradient
#   rc:  Radial Cuts
#   rm:  Raw He Solution Matrix
#   sm:  Smoothed He Solution Matrix
#   zm:  Zero Solution Matrix

   set euvANS(PiD) [ list  mi  si  ls  ra  eq  ps  rg  ag  rc  rm  sm  zm ] 
   set PDo         [ list   1   1   1   1   0   1   0   0   0   0   0   0 ]
   set PPg         [ list   0   0   0   0   3   1   2   2  50  51  52  53 ]
   set PSca        [ list   1   1   0   0   1   1   0   0   0   0   0   0 ]
   set PWn         [ list   2   2   2   2   6   3   3   3   5   4   4   4 ]

   set PMin        [ list     1.00      1.00      8.00     -1.00      1.00 \
                              0.01  \
                          -2000.00  -2000.00      0.00     -2.00     -2.00 \
                              0.10 ]

   set PMax        [ list  1500.00   1500.00      1.00      1.00   1500.00 \
                           1500.00  \
                            500.00    500.00     24.00      3.50      3.50 \
                              0.90 ]


   set PLen  [llength $euvANS(PiD)]

   for { set I 0 } { $I < $PLen } { incr I } {
      set pID                   [lindex $euvANS(PiD) $I]
      set euvANS(${pID}Do)      [lindex $PDo $I]
      set euvANS(${pID}Dp)      [lindex $PWn $I]
      set euvANS(${pID}Pg)      [lindex $PPg $I]
      set euvANS(${pID}Min)     [lindex $PMin $I]
      set euvANS(${pID}Max)     [lindex $PMax $I]
      set euvANS(${pID}Sca)     [lindex $PSca $I]
      set euvANS(${pID}PScript) 0
      set euvANS(${pID}Sm)      NO
      set euvANS(${pID}Dec)     1
   }
   set euvANS(psMn) 6
   set euvANS(agMn) 6
   set euvANS(rgMn) 6
   set euvANS(eqMn) 6
   set euvANS(rcBg) 0.0
   set euvANS(rcEd) 24.0
   set euvANS(rcDt) 3.0
   set euvANS(rmBg) 0
   set euvANS(rmEd) -1
   set euvANS(rmDt) 1
   set euvANS(smBg) 0
   set euvANS(smEd) -1
   set euvANS(smDt) 1

   set euvANS(thShift)     0.0
   set euvANS(phShift)     0.0
   set euvANS(lMax)       -2.0

   set euvANS(iRes)        .1
   set euvANS(nIter)       6
   set euvANS(zrGrids)     1

   set euvANS(ZMax)       0.75
   set euvANS(ZStepSz)    0.005 

   set euvANS(uBkStat)    0 
   set euvANS(uBkLev)     1 
   set euvANS(cBkStat)    0 
   set euvANS(cBkLev)     1 

##############################################################################

   set euvANS(kP)    -1.0
   set euvANS(F10.7) -1.0
   set euvANS(F30.4) 1.7e10

##############################################################################

##############################################################################
# HERE IS SET THE PLOT ZOOM FACTOR.  1.0 WILL PRODUCE PLOT WINDOWS WHICH
# FIT THE SMALLEST SCREEN LENGTH (MAX SIZE TO EXACTLY FIT THE SCREEN).
# .75 give a size 75% of the shortest length
##############################################################################

   set euvANS(Zoom) .75

##############################################################################
# USE this aspect ratio (Y/X) on all plots which don't need a specific aspect
#    ratio.  This set the X axis to be twice as long as the Y axis.
##############################################################################

   set euvANS(DefAspect) 0.5 

##############################################################################
#  Blank out the mask variables
##############################################################################

  set euvANS(aSide)   0

  for { set I 0 } { $I < 10 } { incr I } {
     set euvANS(TopX$I) "" ; set euvANS(BotX$I) ""
     set euvANS(TopY$I) "" ; set euvANS(BotY$I) ""
     set euvANS(RightX$I) "" ; set euvANS(LeftX$I) ""
     set euvANS(RightY$I) "" ; set euvANS(LeftY$I) ""
  }

##############################################################################
# THIS is the fit coefficients that give the He+ density as a function
#    of geomagnetic latitude
##############################################################################

   set euvANS(LatDenM) 0
   set euvANS(LDenF)   ""

#  set euvANS(ndC) 8
#  set dCoef(0) 1.02207781901
#  set dCoef(1) 9.25889593892e-15
#  set dCoef(2) -0.39860906068
#  set dCoef(3) -4.63089041582e-14
#  set dCoef(4) 0.843894342119
#  set dCoef(5) 5.16329041934e-14
#  set dCoef(6) -0.194778289016
#  set dCoef(7) -1.57285240073e-14

   set euvANS(ndC) 1
   set dCoef(0) 1.0
   set dCoef(1) 1.0

   set euvANS(UsedScr) ""
}
