package provide EUVSim 1.0

proc PlotOptMenu {  } {
   global euvANS env Prefs

# LETS make the labels in the menu bold and titles a little larger
                                                                                
   set LFonT [list fixed $Prefs(FontSize) bold]
   set TFonT [list fixed [expr $Prefs(FontSize) + 4] bold ]
   set tC #0F0FAF


   set W  .giPLOT

   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "EUV INVERSION PLOT PAGE"
      wm withdraw $W

      set Wa .giPLOT.top
      set Wb .giPLOT.opts

      GUIFrame $Wa -1 pack|top||both
      GUIFrame $Wb -1 pack|top||both

      GUILabel $Wa.lxm "Zoom" c pack|left 0 0 "" $LFonT
      GUIboxEntry $Wa.zm  pack|left 7 euvANS(Zoom)
      GUILabel $Wa.lab "PLOT DEFINITION MENU" c pack|left|center|x|true \
               0 0 "" [list fixed 16]
      GUIbuttonPush $Wa.close CLOSE pack|right "wm withdraw $W" 6

      set Row 0
      GUILabel $Wb.lcb "ColorBar Info" c grid|$Row|3|ew||3 0 0 $tC $TFonT
      incr Row
      GUIblankRow $Wb $Row 1.0
      incr Row
      set Col 1
      GUILabel $Wb.lbdp  "Plot"   c grid|$Row|$Col|ew 0 0 "" $LFonT; incr Col 
      GUILabel $Wb.lbpg  "Page"   c grid|$Row|$Col|ew 0 0 "" $LFonT; incr Col
      GUILabel $Wb.lbmin "Min"    c grid|$Row|$Col|ew 0 0 "" $LFonT; incr Col
      GUILabel $Wb.lbmax "Max"    c grid|$Row|$Col|ew 0 0 "" $LFonT; incr Col
      GUILabel $Wb.lbsc  "Scale"  c grid|$Row|$Col|ew 0 0 "" $LFonT; incr Col
      GUILabel $Wb.lbps  "Png"    c grid|$Row|$Col|ew 0 0 "" $LFonT 

      incr Row
      set Ops1 [list LINEAR|0 LOG|1]
      set Ops2 [list NO|0 YES|1]
      set Ops3 [list NO|0 3x3L|1 5x5L|2 3x3H|3 5x5H|4]
      set Ops4 [list NO|0 XY|1 PT|2]

      set PList [list "MEASURED IMAGE" "SIMULATED IMAGE" "L SHELL" "RATIO" \
                      "SM MEASURED IMAGE" \
                      "PLASMASPHERE" "RADIAL GRADIENT" "AZIMUTHAL GRADIENT" \
                      "RADIAL CUTS" "RAW He MATRIX" \
                      "SMOOTHED He MATRIX" "ZERO MATRIX"]

      set PLen [llength $PList]

      for { set I 0 } { $I < $PLen } { incr I } {
         set Col 1
         set PName [lindex $PList $I ]
         set pID [lindex $euvANS(PiD) $I ]

         GUILabel $Wb.l$pID $PName w grid|$Row|0|w 0 0 "" $LFonT

         if { [string compare eq $pID] == 0 } {
            set LaB [lindex [split [lindex $Ops4 $euvANS(${pID}Do)] "|"] 0]
            GUIbuttonMenu $Wb.${pID}do $LaB grid|$Row|$Col|ew $Ops4 \
                "GUIoptsProcess $Wb.${pID}do euvANS(${pID}Do) ALT " 6
         } else { 
            set LaB [lindex [split [lindex $Ops2 $euvANS(${pID}Do)] "|"] 0]
            GUIbuttonToggle $Wb.${pID}do $LaB grid|$Row|$Col|ew \
                 $Ops2 "GUIoptsToggle $Wb.${pID}do euvANS(${pID}Do) ALT " 6
         }
         incr Col
         GUIboxEntry $Wb.${pID}pg  grid|$Row|$Col 7 euvANS(${pID}Pg)
         incr Col
         GUIboxEntry $Wb.${pID}min grid|$Row|$Col 7 euvANS(${pID}Min)
         incr Col
         GUIboxEntry $Wb.${pID}max grid|$Row|$Col 7 euvANS(${pID}Max)
         incr Col
         set LaB [lindex [split [lindex $Ops1 $euvANS(${pID}Sca)] "|"] 0]
         GUIbuttonToggle $Wb.${pID}sca $LaB grid|$Row|$Col|ew \
              $Ops1 "GUIoptsToggle $Wb.${pID}sca euvANS(${pID}Sca) ALT " 6
         incr Col
         set LaB [lindex [split [lindex $Ops2 $euvANS(${pID}PScript)] "|"] 0]
         GUIbuttonToggle $Wb.${pID}ps $LaB grid|$Row|$Col|ew \
              $Ops2 "GUIoptsToggle $Wb.${pID}ps euvANS(${pID}PScript) ALT " 6
         incr Col
         incr Row
      }

      GUIblankRow $Wb $Row 2.0
      incr Row
      GUILabel $Wb.lex "Extra Info" c grid|$Row|1|ew||3 0 0 $tC $TFonT
      incr Row
      GUIblankRow $Wb $Row 1.0
      incr Row
      set Col 1
      GUILabel $Wb.elbmax "MinR"   c grid|$Row|$Col|ew 0 0 "" $LFonT; incr Col
      GUILabel $Wb.elbsm  "Filter" c grid|$Row|$Col|ew 0 0 "" $LFonT; incr Col
      GUILabel $Wb.elbdc  "Decim"  c grid|$Row|$Col|ew 0 0 "" $LFonT; incr Col
      GUILabel $Wb.elbst  "Start"  c grid|$Row|$Col|ew 0 0 "" $LFonT; incr Col
      GUILabel $Wb.elbed  "End"    c grid|$Row|$Col|ew 0 0 "" $LFonT; incr Col
      GUILabel $Wb.elbdt  "Delta"  c grid|$Row|$Col|ew 0 0 "" $LFonT

# SM Image extras

      incr Row
      GUILabel $Wb.eleq "SM MEASURED IMAGE" w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wb.eqmn grid|$Row|1 7 euvANS(eqMn)
      GUIbuttonMenu $Wb.eqsm $euvANS(eqSm) grid|$Row|2 $Ops3  \
           "GUIoptsProcess $Wb.eqsm euvANS(eqSm) PRI " 6
      GUIboxEntry $Wb.eqdec grid|$Row|3 7 euvANS(eqDec)

# PLASMASPHERE extras

      incr Row
      GUILabel $Wb.elps PLASMASPHERE w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wb.psmn grid|$Row|1 7 euvANS(psMn)
      GUIbuttonMenu $Wb.pssm $euvANS(psSm) grid|$Row|2 $Ops3  \
           "GUIoptsProcess $Wb.pssm euvANS(psSm) PRI " 6
      GUIboxEntry $Wb.psdec grid|$Row|3 7 euvANS(psDec)

# RADIAL GRADIENT extras

      incr Row
      GUILabel $Wb.elrg "RADIAL GRADIENT" w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wb.rgmn grid|$Row|1 7 euvANS(rgMn)
      GUIbuttonMenu $Wb.rgsm $euvANS(rgSm) grid|$Row|2 $Ops3  \
           "GUIoptsProcess $Wb.rgsm euvANS(rgSm) PRI " 6
      GUIboxEntry $Wb.rgdec grid|$Row|3 7 euvANS(rgDec)

# AZIMUTHAL GRADIENT extras

      incr Row
      GUILabel $Wb.elag "AZIMUTHAL GRADIENT" w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wb.agmn grid|$Row|1 7 euvANS(agMn)
      GUIbuttonMenu $Wb.agsm $euvANS(agSm) grid|$Row|2 $Ops3  \
           "GUIoptsProcess $Wb.agsm euvANS(agSm) PRI " 6
      GUIboxEntry $Wb.agdec grid|$Row|3 7 euvANS(agDec)

# RADIAL CUT extras

      incr Row
      GUILabel $Wb.elrc "RADIAL CUTS" w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wb.rcbg grid|$Row|4 7 euvANS(rcBg)
      GUIboxEntry $Wb.rced grid|$Row|5 7 euvANS(rcEd)
      GUIboxEntry $Wb.rcdt grid|$Row|6 7 euvANS(rcDt)

# RAW He MATRIX extras

      incr Row
      GUILabel $Wb.elrm "RAW He MATRIX" w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wb.rmbg grid|$Row|4 7 euvANS(rmBg)
      GUIboxEntry $Wb.rmed grid|$Row|5 7 euvANS(rmEd)
      GUIboxEntry $Wb.rmdt grid|$Row|6 7 euvANS(rmDt)

# SMOOTHED He MATRIX extras

      incr Row
      GUILabel $Wb.elsm "SMOOTHED He MATRIX" w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wb.smbg grid|$Row|4 7 euvANS(smBg)
      GUIboxEntry $Wb.smed grid|$Row|5 7 euvANS(smEd)
      GUIboxEntry $Wb.smdt grid|$Row|6 7 euvANS(smDt)
   }
}
