package provide EUVSim 1.0

# THIS procedure manages the plot state button and any actions it provides.

proc PlotAct { } {
   global GphInfo euvANS env Yr Dy Msec Trigger pDone

   set NoPS    1
   set NoClear 1
   set NoUnset 1

   switch -exact -- $euvANS(pState) {
      START  {
         if { $euvANS(AnyNonPS) == 0 } {
            set euvANS(pState) AUTO
         } else { set euvANS(pState) SINGLE }
      } 

      NEXT  {
         GUIstateSet .giINFO.cmd.next PBUTTON normal
         set NoPS 0
      } 

      SDONE  {
         set TiMe [TUtimeFmt 2 $Yr(0) $Dy(0) $Msec(0)]
         set NoClear 0
         set NoUnset 0
         set euvANS(pState) SINGLE
      }

      ADONE  {
         set TiMe [TUtimeFmt 2 $Yr(0) $Dy(0) $Msec(0)]
         set NoPS 0
         set NoClear 0
         set NoUnset 0
         set euvANS(pState) AUTO
      } 
   }

   if !$NoPS {
      set aLen [llength $euvANS(UsedScr)]
      for { set I 0 } { $I < $aLen } { incr I } {
         set ScrInfo [lindex $euvANS(UsedScr) $I]
         set PiD [lindex $ScrInfo 0]
         set cN  [lindex $ScrInfo 1]
         if ![info exists pNum($PiD)] { set pNum($PiD) 0 }
         if { $euvANS(${PiD}PScript) == 1 } {
            set fName ${PiD}${TiMe}_$pNum($PiD)
            incr pNum($PiD)
            $cN.drw postscript -colormap colorMap -file $fName.ps
            if ![catch { exec convert $fName.ps $fName.png } OuT ] {
               file delete -force $fName.ps
            }
         }
      }
   }

   if !$NoClear {
      set aLen [llength $euvANS(UsedScr)]
      for { set I 0 } { $I < $aLen } { incr I } {
         set ScrInfo [lindex $euvANS(UsedScr) $I]
         set PiD [lindex $ScrInfo 0]
         set cN  [lindex $ScrInfo 1]
         $cN.drw delete GeNeRiC
      }
   }

   if !$NoUnset {
      set euvANS(UsedScr) ""
      if [info exists pDone] { unset pDone }
   }

   update
}
