package provide EUVSim 1.0

# THIS procedure opens all of the UDF data files to be used in the simulation.
#   The sources are all hard coded but this doesn't mean that the data will
#   be online.  In some cases it has to be in others we can accept user input.

proc OpenUDFfiles { SetUpInfo } {
   global euvANS Pidf0 ExPhi0 ExDa SuN SaT SpiN WinInfo SInfo

   upvar $SetUpInfo sI
   set Ver 0
   set N 0
   UDFInits

#  SET the UDF Keys which will be used. 

   set KeY(0) [GetDataKey IMAGE IMAGE1 EUV EUVSCI IMES0IMG]
   set KeY(1) [GetDataKey IMAGE IMAGE1 EUV EUVSCI IMES1IMG]
   set KeY(2) [GetDataKey IMAGE IMAGE1 EUV EUVSCI IMES2IMG]
   set KeY(3) [GetDataKey IMAGE IMAGE1 OA ORBIT IMOORBIT]
   set KeY(4) [GetDataKey GEOSOLARIND INDICES 3-HOUR 3-HOUR GSIKP]
   set KeY(5) [GetDataKey GEOSOLARIND INDICES DAILY DAILY GSISOPL]
   set KeY(6) [GetDataKey GEOSOLARIND INDICES DAILY DAILY GSIF304]

#  OPEN IMES0IMG at the time requested and then use the time returned as the
#     start time for everything else.

   FileOpen $KeY(2) $Ver $euvANS(begYr) $euvANS(begDy) $euvANS(begHr) \
                         $euvANS(begMn) $euvANS(begSc) $euvANS(endYr) \
                         $euvANS(endDy) $euvANS(endHr) $euvANS(endMn) \
                         $euvANS(endSc) 
   set kV $KeY(2),$Ver
   if { $SInfo($kV,FSTATUS) == 1 } {
      set OpEn(2) 1 
      FilePos $KeY(2) $Ver $euvANS(begYr) $euvANS(begDy) $euvANS(begHr) \
                           $euvANS(begMn) $euvANS(begSc) 
   } else { set OpEn(2) 0 } 
   ReadUDF $KeY(2) $Ver $N 0 0 0 0
   set Time2 [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC)]
   set Time [TUtimeFmt 1 $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC)]
   set euvANS(begYr) [lindex $Time 0]
   set euvANS(begDy) [lindex $Time 1]
   set euvANS(begHr) [lindex $Time 2]
   set euvANS(begMn) [lindex $Time 3]
   set euvANS(begSc) [lindex $Time 4]

#  DO the file opens and and time positions
   
   for { set I 0 } { $I < 7 } { incr I } {
      if { $I == 2 } { continue } 
      FileOpen $KeY($I) $Ver $euvANS(begYr) $euvANS(begDy) $euvANS(begHr) \
                             $euvANS(begMn) $euvANS(begSc) $euvANS(endYr) \
                             $euvANS(endDy) $euvANS(endHr) $euvANS(endMn) \
                             $euvANS(endSc) 
      set kV $KeY($I),$Ver
      if { $SInfo($kV,FSTATUS) == 1 } {
         set OpEn($I) 1 
         FilePos $KeY($I) $Ver $euvANS(begYr) $euvANS(begDy) $euvANS(begHr) \
                                $euvANS(begMn) $euvANS(begSc) 
      } else { set OpEn($I) 0 } 
   }

#  WE can fake not being able to open the last three UDF's but we need
#    the data from the first 4 so if any of these is not available
#    we're done.

   for { set I 0 } { $I < 4 } { incr I } {
      if { $OpEn($I) == 0 } { exit }
   }

   ReadUDF $KeY(0) $Ver $N "" 0  0  0
   set Time0 [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC)]
   ReadUDF $KeY(1) $Ver $N "" 0  0  0
   set Time1 [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC)]

   if {[TUtimeCmp 0 $Time0 $Time1] > 0 } { ReadUDF $KeY(1) $Ver $N 0 0 1 0 }
   if {[TUtimeCmp 0 $Time0 $Time2] > 0 } { ReadUDF $KeY(2) $Ver $N 0 0 1 0 }


#  NOW we need to connect units with the sensors.  NOTE that if the 
#     sensor is an auxillary data sensor then use a sensor number of 0.

#  GET the EUV sky map information here.  For each senosr set the Key, the
#    VIDF sensor number, the sensor units and the scan units.

#  IMES0IMG provides not only the IMAGE but also we get the satellite spin
#    vector from this UDF

   ReadPIDF   $KeY(0)
   set sI(0)  $KeY(0)
   set sI(1)  0
   set sI(2)  [UTILunits $KeY(0),$Ver 15 $sI(1)]
   set sI(3)  [UTILunits $KeY(0),$Ver  8 $sI(1)]

   set sI(36) $KeY(0)
   set sI(37) 0
   set sI(38) [UTILunits $KeY(0),$Ver 12 13]
   set sI(39) 0

   set sI(40) $KeY(0)
   set sI(41) 0
   set sI(42) [UTILunits $KeY(0),$Ver 13 14]
   set sI(43) 0

   set sI(44) $KeY(0)
   set sI(45) 0
   set sI(46) [UTILunits $KeY(0),$Ver 14 15]
   set sI(47) 0

   ReadPIDF   $KeY(1)
   set sI(4)  $KeY(1)
   set sI(5)  0
   set sI(6)  [UTILunits $KeY(1),$Ver 15 $sI(5)]
   set sI(7)  [UTILunits $KeY(1),$Ver  8 $sI(5)]

   ReadPIDF   $KeY(2)
   set sI(8)  $KeY(2)
   set sI(9)  0
   set sI(10) [UTILunits $KeY(2),$Ver 15 $sI(9)]
   set sI(11) [UTILunits $KeY(2),$Ver  8 $sI(9)]

   ReadPIDF   $KeY(3)
   set sI(12) $KeY(3)
   set sI(13) 18
   set sI(14) [UTILunits $KeY(3),$Ver  2 $sI(13)]
   set sI(15) 0

   set sI(16) $KeY(3)
   set sI(17) 19
   set sI(18) [UTILunits $KeY(3),$Ver  2 $sI(17)]
   set sI(19) 0

   set sI(20) $KeY(3)
   set sI(21) 20
   set sI(22) [UTILunits $KeY(3),$Ver  2 $sI(21)]
   set sI(23) 0

   set sI(24) $KeY(3)
   set sI(25) 0
   set sI(26) [UTILunits $KeY(3),$Ver  0 $sI(25)]
   set sI(27) 0

   set sI(28) $KeY(3)
   set sI(29) 1
   set sI(30) [UTILunits $KeY(3),$Ver  0 $sI(29)]
   set sI(31) 0

   set sI(32) $KeY(3)
   set sI(33) 2
   set sI(34) [UTILunits $KeY(3),$Ver  0 $sI(33)]
   set sI(35) 0

   if { $OpEn(4) == 1 } {
      ReadPIDF   $KeY(4)
      set sI(48) $KeY(4)
      set sI(49) 0
      set sI(50) [UTILunits $KeY(4),$Ver  1 $sI(49)]
      set sI(51) 0
   } else { set sI(51) -1 }

   if { $OpEn(5) == 1 } {
      ReadPIDF   $KeY(5)
      set sI(52) $KeY(5)
      set sI(53) 6
      set sI(54) [UTILunits $KeY(5),$Ver  7 $sI(53)]
      set sI(55) 0
   } else { set sI(55) -1 }

   if { $OpEn(6) == 1 } {
      ReadPIDF   $KeY(6)
      set sI(55) $KeY(6)
      set sI(56) 1
      set sI(57) [UTILunits $KeY(6),$Ver  1 $sI(56)]
      set sI(58) 0
   } else { set sI(58) -1 }
}
