# THIS procedure looks for hot spots in the He solution matrix and removes
#   them by setting them to the value of the neighbor with the highest value. 
#   This corrects only the base values and so should be run prior to filling
#   the empty grids.

package provide EUVSim 1.0

proc HotSpot { Grid Norm gInfo } {
   global euvANS

   upvar $Grid  G
   upvar $Norm  N
   upvar $gInfo gI

# THE total number of elements in the matrix

   set nG [expr int($gI(4) * $gI(5))]

# THIS is the factor to use in determining if we have a hot element.  An
#    element is considered to be HOT if its intensity is greater than the 
#    intensity of any nearest neighbor by this factor.  The nearest
#    neighbor must be a fixed and not a filled element.

   set Over $euvANS(hsOver)

#  THIS is the base value.  Values below the base value are ignored.

   set Base $euvANS(hsBase)

# LOOP over all the elements in the matrix

   for { set I 0 } { $I < $nG } { incr I } { 

# ONLY consider an element if it is above the lower cutoff value and if
#   something was placed in the grid

      if { ($G($I) > $Base) && ($N($I) > 0.0) } {

# STARTING at the found element start searching around it in ever
#   widening squares until we have at least three other elements to
#   compare it to.

         set nN 0
         set L  1
         while { $nN < 3 } { 
            set EnD [TUgridInfo 41 gI gN $I $L] 

# SET up an array containing the intensities of all the nearest neighbors  
#    which were not filled.

            for { set J 0 } { $J < $EnD } { incr J } {
               if { $N($gN($J)) > 0.0 } {
                  set D($nN) $G($gN($J))
                  incr nN
               }
            } 

            incr L
         }

#  Correction can only be made if we found some nearest neighbors.

         if { $nN > 0 } { 

# GET the maximun intensity among the nearest neighbors and from it get
#   the value which defines a hot spot

            set Closest $D([TUdataMxMn D $nN >])
            set Mx [expr $Over * $Closest]

# IF this element is HOT then set it to the greatest intensity among its
#   nearest neighbors

            if { $Mx < $G($I) } { set G($I) $Closest }
         }
      }
   }
}
