package provide EUVSim 1.0

#  THIS procedure reads in all the data necessary to do a single inversion.
#    The ancillary data is located according to the begin time og the EUV 
#    image being inverted.

proc GetUDFdata { SetUpInfo } {
   global euvANS ExDa SuN SaT SpiN Yr Dy Msec tiImG WinInfo gBIM SInfo

   upvar $SetUpInfo sI

   TimeOut NEW
   PlotStep "READ DATA"

   set Ver 0
   set N 0

# INITIALIZE the image grid now then set the action to ADD

   set gBIM(10) NEW
   TUdataGrid 0 1 Dummy Dummy 1 Dummy Dummy Dummy tiImG NrM gBIM
   set gBIM(10) ADD

# START by getting the spin vector orientation - this is the XYZ components in 
#    GCI and is obtained from the first EUV IMAGE head UDF definition.

   ReadUDF $sI(36) $Ver $N $sI(37) 0 0 0
   set SpiN(0) [ConvertToUnits $sI(36) $Ver 0 $sI(38) Data ] 
   ReadUDF $sI(40) $Ver $N $sI(41) 0 0 0
   set SpiN(1) [ConvertToUnits $sI(40) $Ver 0 $sI(42) Data ] 
   ReadUDF $sI(44) $Ver $N $sI(45) 0 0 0
   set SpiN(2) [ConvertToUnits $sI(44) $Ver 0 $sI(46) Data ] 

# GET the Image. Data is in three separate UDF's - one per head.  To keep the 
#    C TUdataGrid from beating itself to death transfering the data mesh back 
#    and forth between C and Tcl accumulate one full set of of scan lines from 
#    all three heads before gridding.

   set V1  [clock clicks -milliseconds]
   for { set I 0 } { $I < 600 } { incr I } {
      if { $I == 599 } { set FwD 1 } else { set FwD 0 }
      ReadUDF $sI(0) $Ver $N $sI(1) $I $FwD 0

      set nSmp $ExDa($N,NSMP)
      if {$I == 0 } {
         set Yr(0) $ExDa($N,BYR) 
         set Dy(0) $ExDa($N,BDY) 
         set Msec(0) $ExDa($N,BMSEC)
         set euvANS(TmH0) [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) 0]
         set euvANS(TmH0) [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) 0]
         PlotStep "" 1
      }
      set nP 0
      BufferScanLine $N $nP $nSmp sI 0 3 2 ScanD SenD Phi
      incr nP $nSmp

      ReadUDF $sI(4) $Ver $N $sI(5) $I $FwD 0
      if {$I == 0 } {
         set euvANS(TmH1) [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) 0]
      }
      BufferScanLine $N $nP $nSmp sI 4 7 6 ScanD SenD Phi
      incr nP $nSmp

      ReadUDF $sI(8) $Ver $N $sI(9) $I $FwD 0
      if {$I == 0 } {
         set euvANS(TmH2) [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) 0]
      }
      BufferScanLine $N $nP $nSmp sI 8 11 10 ScanD SenD Phi
      incr nP $nSmp

      TUdataGrid $nP 1 ScanD ScanD 1 Phi Phi SenD tiImG NrM gBIM
   }

   set V2  [clock clicks -milliseconds]
   TimeOut READ [expr ($V2 - $V1)/1000.0]

# TERMINATE the image plot

   set gBIM(10) END
   TUdataGrid $nP 1 Dummy Dummy 1 Dummy Dummy Dummy tiImG NrM gBIM

# GET the ending time for the image

   set Yr(1) $ExDa($N,EYR) 
   set Dy(1) $ExDa($N,EDY) 
   set Msec(1) $ExDa($N,EMSEC)
   set Tm0 [format "%04d%03d%08d" $Yr(0) $Dy(0) $Msec(0)]
   set Tm1 [format "%04d%03d%08d" $Yr(1) $Dy(1) $Msec(1)]

# GET the start time of the image in HR MN SS.  This is used to position 
#   ourselves in the ancillary data files 

   set TimE [TUtimeFmt 1 $Yr(0) $Dy(0) $Msec(0)]

#  GET the Satelite and Sun position in GCI from the OA data.  First step is to
#     get to the start image time in the file.  

   FilePos $sI(12) $Ver $Yr(0) $Dy(0) [lindex $TimE 2] [lindex $TimE 3] \
           [lindex $TimE 4] COARSE 1

#  THERE may be multiple measurements over the time span of the image.  Get 
#     them all then average in the end.

   set OK 1
   set nD 0.0;
   for { set I 0 } { $I < 3 } { incr I } {
     set SuN($I) 0.0 
     set SaT($I) 0.0 
   }

   while { $OK } {
      ReadUDF $sI(12) $Ver $N $sI(13) 0 0 0
      set SuN(0) [expr $SuN(0) + [ConvertToUnits $sI(12) $Ver 0 $sI(14) Data]] 
      ReadUDF $sI(16) $Ver $N $sI(17) 0 0 0
      set SuN(1) [expr $SuN(1) + [ConvertToUnits $sI(16) $Ver 0 $sI(18) Data]] 
      ReadUDF $sI(20) $Ver $N $sI(21) 0 0 0
      set SuN(2) [expr $SuN(2) + [ConvertToUnits $sI(20) $Ver 0 $sI(22) Data]] 
      ReadUDF $sI(24) $Ver $N $sI(25) 0 0 0
      set SaT(0) [expr $SaT(0) + [ConvertToUnits $sI(24) $Ver 0 $sI(26) Data]] 
      ReadUDF $sI(28) $Ver $N $sI(29) 0 0 0
      set SaT(1) [expr $SaT(1) + [ConvertToUnits $sI(28) $Ver 0 $sI(30) Data]] 
      ReadUDF $sI(32) $Ver $N $sI(33) 0 1 0
      set SaT(2) [expr $SaT(2) + [ConvertToUnits $sI(32) $Ver 0 $sI(34) Data]] 
      set Tm [format "%04d%03d%08d" $ExDa($N,EYR) $ExDa($N,EDY) $ExDa($N,EMSEC)]
      set tList [lsort -ascii -increasing [list $Tm0 $Tm1 $Tm]]
      set Pos [lsearch -exact $tList $Tm]
      if {$Pos == 2 } { set OK 0 }
      set nD [expr $nD + 1.0]
   }


   for { set I 0 } { $I < 3 } { incr I } {
      set SuN($I) [expr $SuN($I) / $nD] 
      set SaT($I) [expr $SaT($I) / $nD] 
   }

#  GET the Kp data. 

   if { $sI(51) == 0 } {
      FilePos $sI(48) $Ver $Yr(0) $Dy(0) [lindex $TimE 2] [lindex $TimE 3] \
               [lindex $TimE 4] FINE 1
      ReadUDF $sI(48) $Ver $N $sI(49) 0 0 0
      set euvANS(kP) [ConvertToUnits $sI(48) $Ver 0 $sI(50) Data ] 
   }

#  GET the F10.7 data. 

   if { $sI(55) == 0 } {
      FilePos $sI(52) $Ver $Yr(0) $Dy(0) [lindex $TimE 2] [lindex $TimE 3] \
               [lindex $TimE 4] FINE 1
      ReadUDF $sI(52) $Ver $N $sI(53) 0 0 0
      set euvANS(F10.7) [ConvertToUnits $sI(52) $Ver 0 $sI(54) Data ] 
   }

#  GET the F30.4 data. 

   if { $sI(58) == 0 } {
      FilePos $sI(55) $Ver $Yr(0) $Dy(0) [lindex $TimE 2] [lindex $TimE 3] \
               [lindex $TimE 4] FINE 1
      ReadUDF $sI(55) $Ver $N $sI(56) 0 0 0
      set euvANS(F30.4) [ConvertToUnits $sI(55) $Ver 0 $sI(57) Data ] 
   }
   
   set MseC [expr $euvANS(endHr) * 3600000 + $euvANS(endMn) * 60000 + \
                  $euvANS(endSc) * 1000 ]
   set fTm [format "%4d%03d%08d" $euvANS(endYr) $euvANS(endDy) $MseC]
   set cTm [format "%4d%03d%08d" $Yr(1) $Dy(1) $Msec(1)]
   set tList [lsort -ascii -increasing [list $fTm $cTm]]
   set Pos [lsearch -exact $tList $cTm]

   return $Pos
}
