package provide EUVSim 1.0

proc GetLoc { W X Y } {
   global GphInfo DevInfo WinInfo PltInfo euvANS 

# IF no plot has been put up there is nothing to do

   if ![info exists GphInfo(CurScr)] { return }

# Determine what we are defining

   switch -exact -- $euvANS(aSide) {
      0  { return       }
      1  { set iD Top   }
      2  { set iD Bot   }
      3  { set iD Left  }
      4  { set iD Right }
   }

   set J 0
   set PoS -1
   while { ($J < 10 ) && ($PoS == -1) } {
      set xL [string length $euvANS(${iD}X$J)]
      set yL [string length $euvANS(${iD}Y$J)]
      if { ($xL == 0) || ($yL == 0) } { set PoS $J }
      incr J
   }
                                                                                
# GET mi plot window, plot number, screen iD, and canvas number

   set pN $euvANS(miPg)
   set sN [lindex $euvANS(sN$pN) 0]
   set sC Scr[lindex $euvANS(sN$pN) 0]
   set cN [lindex $euvANS(pW$pN) 0]
   set wN $euvANS(miDp)

# THIS is the mi plot window bounds.  Arrange both x and y so that 
#   min is the smaller of the two

   set xMN $WinInfo($wN,pp0)
   set yMN $WinInfo($wN,pp1)
   set xMX $WinInfo($wN,pp3)
   set yMX $WinInfo($wN,pp4)

   if { $xMN > $xMX } { set TmP $xMN ; set xMN $xMX ; set xMX $TmP }
   if { $yMN > $yMX } { set TmP $yMN ; set yMN $yMX ; set yMX $TmP }

# GET the mouse coordinates
                                                                                
   set DevInfo($sC.mW) $W
   set DevInfo($sC.mX) $X
   set DevInfo($sC.mY) $Y
   set DevInfo($sC.mS) 1
   set BaD 1

   set In(0) $X
   set In(1) $Y

# GET physical coordinates in plot.  They are bad if outside the plot
#    boundaries

   GPHretCoor $wN In Out SCALED
   if { ($Out(0) >= $xMN) && ($Out(0) <= $xMX) } {
      if { ($Out(1) >= $yMN) && ($Out(1) <= $yMX) } { set BaD 0 }
   }

   if !$BaD  {
      set euvANS(${iD}X$PoS) [format "%.2f" $Out(0) ] 
      set euvANS(${iD}Y$PoS) [format "%.2f" $Out(1) ]

      set GphInfo(CurScr) $sN
      set TaG ${iD}$PoS
      TextProp 10
      TexT $wN $euvANS(${iD}X$PoS) $euvANS(${iD}Y$PoS) 0.0 center \
                      "+" $GphInfo(White) 0.0 $TaG
   } 

   update
}
