package provide EUVSim 1.0

#  THIS is the main procedure coming out of the menus which calls all 
#     the necessary routines to establish, display, and dump the inversion
#     data.

proc DoSim { } {
   global euvANS Re pDone Trigger gIMG

# DO all setup of variables which depend on variables which may have been
#    altered in the menu. 

   PostMenuSetup

# SET up all of the plot labels which may be used.

   PlotLabSetup

# FIRE up window into which all of the timing information is set as the
#   inversion moves along.  These are wall clock settings which gives
#   the time it takes to perform various steps.

   TimeMenu

# FIRE up the graphics

   StartGraphics

# GET all of the UDF data that will be needed.  This is basically the EUV
#    data as well as some ancillary data which is needed by the model

   OpenUDFfiles SetupInfo


   if { $euvANS(AnyNonPS) == 0 } {
      set euvANS(StepC) black
   } else { set euvANS(StepC) #0F0FAF }

   PlotAct

# RUN the simulation 

   while { [GetUDFdata SetupInfo] == 0 } {
      if ![ReSync SetupInfo] {
         SetGridSize
         if [DynamicPlots] { 
            if $euvANS(NeedSim) {
               RunModel
               ProcessData
               EquatorialPlot PS
            }
            if { $euvANS(TotP) > 0 } { 
               if $euvANS(NeedLoS) { LinesOfSight LOS }
               EquatorialPlot MI
               PlotResults 
            } 
            if [string match SINGLE $euvANS(pState)] { 
               set euvANS(pState) NEXT
               PlotAct
               tkwait variable Trigger
               unset Trigger
               GUIstateSet .giINFO.cmd.next PBUTTON muted
            } else { set euvANS(pState) ADONE ; PlotAct }
         }
         incr euvANS(iCnT)
      }
      FreeUp
   }
}
