package provide EUVSim_C 1.0

proc ColDen2D { gN dL nRC nPC Coef Mesh mInfo } {
   global Re PI

   upvar $Coef A
   upvar $Mesh dM
   upvar $mInfo mI

# SET up a few constants particularly those needed to skip to different
#    coefficients in the coefficient arrays.

   set nPI [expr -$PI]
   set IncX [expr abs(($mI(1) - $mI(0))) / $mI(4)]
   set IncY [expr abs(($mI(3) - $mI(2))) / $mI(5)]

   set nC [expr $nRC + $nPC + 2]
   set ToC [expr $gN * (2 * $nC + 2)]
   set MinR $A($ToC)
   set MaxR $A([expr $ToC + 1])
 
   incr ToC 2
   set MinL(0) $A([expr $ToC + 0])
   set MinL(1) $A([expr $ToC + $nC])
   incr ToC 2

   set ToP [expr $ToC + $nRC]

# Initialize the summation variable 

   set cD 0.0
 
# SINCE L is double valued along the line of sight there are two fits to
#    return Position as a function L.  The outer loop takes care of the
#    dual fits.  Only need to look at a fit however if it was produced.

   for { set J 0 } { $J < 2 } { incr J ; incr ToC $nC ; incr ToP $nC } {
      if { ($MinL($J) > 1000.0) } { continue } 

# GET the Density, Position, and Longitude of the first L-Shell in the
#    summation.

      set L  $MinL($J)
      set Ra [TUpolyExp1D $L $nRC A $ToC]
      set mL [TUpolyExp1D $L $nPC A $ToP]

      set Y  [expr int(($L - $mI(2)) / $IncY) ]                      
      if { ($Y >= 0) && ($Y < $mI(5)) } { 
         set X [expr int(($mL - $mI(0)) / $IncX) ]                      
         if { $X <  0 } { set X [expr $mI(4) + $X] }
         set X [expr $X % $mI(4)]
         set Pix [expr int($Y * $mI(4) + $X)] 
#        set Da [expr pow(10.0, $dM($Pix))]
         set Da $dM($Pix)
      } else { set Da 0.0 }

# NOW loop over each succeeding L-Shell and integrate the density between
#    the current and the last.  This is a linear integration of the He 
#    density over R.

      set L [expr $MinL($J) + $dL] 
      for { } {$L <= $mI(3)} {set L [expr $L + $dL]} { 
         set Rb [TUpolyExp1D $L $nRC A $ToC]
         set mL [TUpolyExp1D $L $nPC A $ToP]
         set Y  [expr int(($L - $mI(2)) / $IncY) ]                      
         if { ($Y >= 0) && ($Y < $mI(5)) } { 
            set X [expr int(($mL - $mI(0)) / $IncX) ]                      
            if { $X <  0 } { set X [expr $mI(4) + $X] }
            set X [expr $X % $mI(4)]
            set Pix [expr int($Y * $mI(4) + $X)] 
#           set Db [expr pow(10.0, $dM($Pix))]
            set Db $dM($Pix)
         } else { set Db 0.0 }

         set R1 $Ra
         set R2 $Rb
         if { ($Ra >= $MinR) && ($Ra <= $MaxR) } {
            if { ($Rb < $MinR) } {
                set R1 $MinR
            } elseif { ($Rb > $MaxR) } {
                set R1 $MaxR
            } else { set R1 $R2 }
         } elseif { ($Rb >= $MinR) && ($Rb <= $MaxR) } {
            if { ($Ra < $MinR) } {
                set R2 $MinR
            } elseif { ($Ra > $MaxR) } {
                set R2 $MaxR
            } else { set R2 $R1 }
         } 

         if { $R1 != $R2 } {
            set dR [expr $Ra - $Rb]
            set Slope [expr ($Da - $Db) / $dR] 
            set Intercept [expr $Da - $Slope * $Ra]
            set colD [expr $dR * (($Ra + $Rb) * $Slope / 2.0 + $Intercept)]
            set cD [expr $cD + abs($colD)]
         } 

# SINCE the bins are contiguous the maximun position of the current bin
#    becomes the minimum postion of the next bin

         set Ra $Rb
         set Da $Db
      }
   }

   return [expr $cD * $Re * 1.0e5]
}
