/*  The C equivalent of Iterate,  It consists of a TCL interface over       */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are  5 OBJV elements.  These are:                                 */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Beginning integration step            (BegI)               */
/*     OBJV[2]:  Integration Step Size                 (dH)                 */
/*     OBJV[3]:  Number of Steps                       (nS)                 */
/*     OBJV[4]:  Current Step                          (cS)                 */

#include <tcl.h>
#include <stdlib.h>
#include <math.h>
#include "ByteDefs.h"
#include "TeuvsimAnsi.h"
#include "TutilAnsi.h"

int Func2DCmd (ClientData Cd, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   static void *memPtr;
   ReaL_8 *V;
   ReaL_8  hTm[3], sTm[3], Xm[3], R, BegI, dH, D, XY, CoeF[20];
   ReaL_8  bX, bY, IncX, IncY, TmP, lS, gLnG, gLaT, LiMs[2];
   ReaL_8  RaD, AnG;
   ByTe_4  I, J, LastS, nX, nY, CoL, RoW, Bytes, Loc, nC;
   int     nS, cS, gN, gF = 0;
   Tcl_Obj *objPtr;
   int Flg = TCL_LEAVE_ERR_MSG;
   char *Value, Index[10];

/* Make sure that all the IO parameters are present */

   if (objc < 5 ) {
      Tcl_WrongNumArgs(tI, 1, objv, "Usage: Func2D ... ");
      return TCL_ERROR;
   }

/* Get the non-array inputs                                                 */

   Tcl_GetDoubleFromObj (tI, objv[1], &BegI);
   Tcl_GetDoubleFromObj (tI, objv[2], &dH);
   Tcl_GetIntFromObj (tI, objv[3], &nS);
   Tcl_GetIntFromObj (tI, objv[4], &cS);

   LastS = nS - 1;

/* Get the global inputs                                                    */

   Tcl_UpVar (tI, "#0", "CurInfo", "cI", 0);
   Tcl_UpVar (tI, "#0", "SaTm", "sT", 0);
   Tcl_UpVar (tI, "#0", "HaTm", "hT", 0);
   Tcl_UpVar (tI, "#0", "HdM", "Hd", 0);
   Tcl_UpVar (tI, "#0", "dCoef", "dC", 0);
   Tcl_UpVar (tI, "#0", "euvANS", "AnS", 0);

   if ((Value = Tcl_GetVar2(tI, "AnS", "ndC", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &TmP);
      nC = TmP;
   } 
   if ((Value = Tcl_GetVar2(tI, "cI", "0", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &TmP);
      gN = TmP;
   } 
   if ((Value = Tcl_GetVar2(tI, "cI", "2", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &bX);
   }
   if ((Value = Tcl_GetVar2(tI, "cI", "3", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &bY);
   }
   if ((Value = Tcl_GetVar2(tI, "cI", "4", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &IncX);
   }
   if ((Value = Tcl_GetVar2(tI, "cI", "5", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &IncY);
   }
   if ((Value = Tcl_GetVar2(tI, "cI", "6", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &TmP);
      nX =TmP;
   }
   if ((Value = Tcl_GetVar2(tI, "cI", "7", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &TmP);
      nY =TmP;
   }
   if ((Value = Tcl_GetVar2(tI, "AnS", "SolGrid", Flg)) != NULL) {
      gF = (strcmp(Value, "PT") == 0) ? 0 : 1;
   }

   J = 3 * gN; 
   for (I = 0; I < 3; ++I, ++J) {
      sprintf (Index, "%d", I);
      if ((Value = Tcl_GetVar2(tI, "sT", Index, Flg)) != NULL) {
         Tcl_GetDouble (tI, Value, &sTm[I]);
      }
      sprintf (Index, "%d", J);
      if ((Value = Tcl_GetVar2(tI, "hT", Index, Flg)) != NULL) {
         Tcl_GetDouble (tI, Value, &hTm[I]);
      }
   }

   for (I = 0; I < nC; ++I) {
      sprintf (Index, "%d", I);
      if ((Value = Tcl_GetVar2(tI, "dC", Index, Flg)) != NULL) {
         Tcl_GetDouble (tI, Value, &CoeF[I]);
      }
   }

   if ( cS <= 0 ) {
      Bytes = nS * sizeof(ReaL_8);
      if ((memPtr = malloc (Bytes)) == NULL)
         return TCL_ERROR;
      V = (ReaL_8 *)memPtr; 
   
      R = BegI;
      for (I = 0; I < nS; ++I, R += dH) {
         for (J = 0; J < 3; ++J ) { Xm[J] = sTm[J] + hTm[J] * R; }
         XY = Xm[0] * Xm[0] + Xm[1] * Xm[1];
         D = XY + Xm[2] * Xm[2];
         lS = D * sqrt(D) / (XY + 1.0e-9);
         gLnG = atan2(Xm[1], Xm[0]);
         gLaT = atan2(Xm[2], XY);
         if (gF == 1) {
            RaD = lS;
            AnG = gLnG;
            gLnG = RaD * cos(AnG);
            lS = RaD * sin(AnG);
         }
         RoW = (lS - bY) / IncY;
         if ((RoW >= 0) && (RoW < nY) ) {
            CoL = (gLnG - bX) / IncX;
            if (CoL < 0) { CoL += nX; } 
            CoL = CoL % nX;
            Loc = (ByTe_4)(RoW * nX + CoL);
            sprintf (Index, "%d", Loc);
            if ((Value = Tcl_GetVar2(tI, "Hd", Index, Flg)) != NULL) {
                Tcl_GetDouble (tI, Value, &TmP);
            }
            V[I] = TmP * PolyExp1D_C(gLaT, nC, CoeF, 0, LiMs);
         } else { V[I] = 0.0; }
      }
   }

   if ( cS < 0 ) {
      CArrayToTcl (tI, objv[5], V, nS, 0, 'D'); 
      free (memPtr);
   } else {
      V = (ReaL_8 *)memPtr; 
      objPtr = Tcl_GetObjResult(tI);
      Tcl_SetDoubleObj (objPtr, (double)V[cS]);
      if (cS == LastS) { free (memPtr); }
   }

   return TCL_OK;
}
