catch {load vtktcl}
if { [catch {set VTK_TCL $env(VTK_TCL)}] != 0} { set VTK_TCL "/opt/vtk/examplesTcl" }

# Generate implicit model of a sphere
#
#source $VTK_TCL/vtkInt.tcl
#source $VTK_TCL/colors.tcl

# Create renderer stuff
#
vtkRenderer ren1
vtkRenderWindow renWin
    renWin AddRenderer ren1
vtkRenderWindowInteractor iren
    iren SetRenderWindow renWin

# create pipeline
#
vtkSphere sphere
    sphere SetRadius .1
vtkSampleFunction sample
    sample SetImplicitFunction sphere
vtkContourFilter iso
    iso SetInput [sample GetOutput]
    iso SetValue 0 0.0
vtkPolyDataMapper isoMapper
    isoMapper SetInput [iso GetOutput]
    isoMapper ScalarVisibilityOff
vtkActor isoActor
    isoActor SetMapper isoMapper
#   eval [isoActor GetProperty] SetColor $peacock
    eval [isoActor GetProperty] SetSpecular 0.8
    eval [isoActor GetProperty] SetSpecularPower 10.0
    eval [isoActor GetProperty] SetDiffuse 0.6
    eval [isoActor GetProperty] SetAmbient 0.0

vtkSphere sat
    sat SetRadius .05
    sat SetCenter .165 .79  .022
vtkSampleFunction samplesat
    samplesat SetImplicitFunction sat
vtkContourFilter isosat
    isosat SetInput [samplesat GetOutput]
    isosat SetValue 0 0.0
vtkPolyDataMapper isosatMapper
    isosatMapper SetInput [isosat GetOutput]
    isosatMapper ScalarVisibilityOff
vtkActor satActor
    satActor SetMapper isosatMapper
#   eval [satActor GetProperty] SetColor $peacock
    eval [satActor GetProperty] SetSpecular 0.8
    eval [satActor GetProperty] SetSpecularPower 10.0
    eval [satActor GetProperty] SetDiffuse 0.6
    eval [satActor GetProperty] SetAmbient 0.0

vtkOutlineFilter outline
    outline SetInput [sample GetOutput]
vtkPolyDataMapper outlineMapper
    outlineMapper SetInput [outline GetOutput]
vtkActor outlineActor
    outlineActor SetMapper outlineMapper
    [outlineActor GetProperty] SetColor 0 0 0

vtkPlane plane1
    plane1 SetOrigin 0 0 0
    plane1 SetNormal 0 1 0
vtkSampleFunction sample1
    sample1 SetImplicitFunction plane1
vtkContourFilter iso1
    iso1 SetInput [sample1 GetOutput]
    iso1 SetValue 0 0.0
vtkPolyDataMapper isoMapper1
    isoMapper1 SetInput [iso1 GetOutput]
    isoMapper1 ScalarVisibilityOff
vtkActor planeActor1
    planeActor1 SetMapper isoMapper1
#   eval [planeActor1 GetProperty] SetColor $blue
#   [planeActor1 GetProperty] SetOpacity 0.5

vtkPlane plane2
    plane2 SetOrigin 0 -0.99 0
    plane2 SetNormal 0 1 0
vtkSampleFunction sample2
    sample2 SetImplicitFunction plane2
vtkContourFilter iso2
    iso2 SetInput [sample2 GetOutput]
    iso2 SetValue 0 0.0
vtkPolyDataMapper isoMapper2
    isoMapper2 SetInput [iso2 GetOutput]
    isoMapper2 ScalarVisibilityOff
vtkActor planeActor2
    planeActor2 SetMapper isoMapper2
#   eval [planeActor2 GetProperty] SetColor $blue

vtkLight Light
  Light SetColor 1 1 1
  Light SetFocalPoint 0 0 0
  Light SetPosition -116 76  55 

vtkCamera camera
   camera SetFocalPoint 0 0 0 
   camera SetPosition 0.0 10.0 0.5
   camera ComputeViewPlaneNormal
   camera SetViewUp  0. 0. 0.
   camera Dolly 1.4


# Add the actors to the renderer, set the background and size
#
ren1 SetActiveCamera camera
#ren1 AddActor outlineActor
ren1 AddActor isoActor
ren1 AddActor satActor
ren1 AddActor planeActor1
ren1 AddActor planeActor2
ren1 AddLight Light
ren1 SetBackground 0 0 0
ren1 LightFollowCameraOff
renWin SetSize 500 500
iren Initialize
iren LightFollowCameraOff

# render the image
#
iren SetUserMethod {wm deiconify .vtkInteract}

#renWin SetFileName "sphere.tcl.ppm"
#renWin SaveImageAsPPM

# prevent the tk window from showing up then start the event loop
wm withdraw .


