# TRANSFORMS an map in measured image coordinates to one in SM coordinates
#   with the same dimension as the plasmasphere density map
#   this could be the plasmasphere or the measured EUV image if it
#   is plotted in SM equatorial plane

package provide EUVSim 1.0

proc XformMap { FmT iArray oArray oAInfo } {
   global euvANS gIMG lsImG gMl xSM ySM 

   upvar $iArray iA
   upvar $oArray oA
   upvar $oAInfo oAI

   set fInfo(0) 1
   set fInfo(1) 4
   set fInfo(2) 4
   set fInfo(3) 2
   set fInfo(4) 0
   set fInfo(5) 0
   set fInfo(6) 0
   set fInfo(7) 0
   set fInfo(8) 2.0
   set nG [expr $gIMG(4) * $gIMG(5)]

   switch -exact -- $FmT {
      PT { TUdataGrid $nG 1 gMl gMl 1 lsImG lsImG iA tA tN oAI }
      XY { TUdataGrid $nG 1 xSM xSM 1 ySM ySM iA tA tN oAI     }
   }

   TUgridFill2D tA oAI tN fInfo
   set nG [expr $oAI(4) * $oAI(5)]
   for { set gN 0  } { $gN < $nG } { incr gN  } {
      if { $tA($gN) <= 0.0 } { set oA($gN) 0.0 } else { set oA($gN) $tA($gN) }
   }
}
