package provide EUVSim 1.0

proc Trace { iD AcTioN } {
   global GphInfo DevInfo WinInfo PltInfo euvANS 

   set pN $euvANS(miPg)
   set sN [lindex $euvANS(sN$pN) 0]
   set sC Scr[lindex $euvANS(sN$pN) 0]
   set cN [lindex $euvANS(pW$pN) 0]
   set wN $euvANS(miDp)

# THIS is the mi plot window bounds.  Arrange both x and y so that 
#   min is the smaller of the two

   set xMN $WinInfo($wN,pp0)
   set yMN $WinInfo($wN,pp1)
   set xMX $WinInfo($wN,pp3)
   set yMX $WinInfo($wN,pp4)
   
   set TaG TaG$iD

   switch -exact -- $iD {
      Top   { set IndeX 0 }
      Bot   { set IndeX 0 }
      Left  { set IndeX 1 }
      Right { set IndeX 1 }
   }

   if [string match ADD $AcTioN] {
      set Val ""
      for { set I 0 } { $I < 10 } { incr I } {
         set xL [string length $euvANS(${iD}X$I)]
         set yL [string length $euvANS(${iD}Y$I)]
         if { ($xL > 0) && ($yL > 0) } { 
	    lappend Val [list $euvANS(${iD}X$I) $euvANS(${iD}Y$I)]
	 }
      }

      set lP [llength $Val]
      if { $lP < 2 } { return }

      set sVal [lsort -real -increasing -index $IndeX $Val]
      set nE [llength $sVal]
      for { set I 0 ; set J 1 } { $I < $nE } { incr I ; incr J } {
         set X($J) [lindex [lindex $sVal $I] 0]
         set Y($J) [lindex [lindex $sVal $I] 1]
      }

      if { $IndeX == 0 } {
         set A [expr ($Y(2) - $Y(1)) / ($X(2) - $X(1))]
         set B [expr $Y(1) - $A * $X(1)]
         set X(0) $xMN
         set Y(0) [expr $A * $xMN + $B]

         set nlP [expr $lP - 1]
         set A [expr ($Y($lP) - $Y($nlP)) / ($X($lP) - $X($nlP))]
         set B [expr $Y($nlP) - $A * $X($nlP)]
         set X($J) $xMX
         set Y($J) [expr $A * $xMX + $B]
      } else {
         set A [expr ($X(2) - $X(1)) / ($Y(2) - $Y(1))]
         set B [expr $X(1) - $A * $Y(1)]
         set X(0) [expr $A * $yMN + $B]
         set Y(0) $yMN

         set nlP [expr $lP - 1]
         set A [expr ($X($lP) - $X($nlP)) / ($Y($lP) - $Y($nlP))]
         set B [expr $X($nlP) - $A * $Y($nlP)]
         set X($J) [expr $A * $yMX + $B]
         set Y($J) $yMX
      }

      set GphInfo(tag) [list $TaG E] 
      PlotColor HOLD $GphInfo(White) OFF
      Lines $wN X Y X [expr $nE + 2]
   } else { $DevInfo($sC).drw delete $TaG }

   update
}
