package provide EUVSim_C 1.0

#  THIS procedure sets the integration limits for a line of sight

proc SetLosEnds { I Lmin dL MinZ } {
   global SaTm SaTmM LoSBeG LoSEnD HaTm

   set P [expr $I * 3]
   set xH $HaTm($P) ; incr P
   set yH $HaTm($P) ; incr P
   set zH $HaTm($P)

# COMPUTE L max in L passband 

   set Lmax [expr $Lmin + $dL]

# COMPUTE L at the satellite

   set XY [expr $SaTm(0) * $SaTm(0) + $SaTm(1) * $SaTm(1) + 1.0e-9]   
   set Ls [expr $SaTmM * $SaTmM * $SaTmM / $XY]

# STAGE 1: Trace L back from the satellite until we get to the point where
#   its inside the maximum L being considered in the solution.

   if { $Ls > $Lmax } {
      set OK 1
      set Zmax $SaTm(2)
      set Zmin $MinZ
      while { $OK } {
         set Z  [expr ($Zmax + $Zmin) / 2.0]
         set tZ [ expr ($Z - $SaTm(2)) / $zH]
         set X  [expr $tZ * $xH +  $SaTm(0)]
         set Y  [expr $tZ * $yH +  $SaTm(1)]
         set XY [expr $X * $X + $Y * $Y + 1.0e-9]   
         set D  [expr sqrt($XY + $Z * $Z)]
         set L  [expr $D * $D * $D / $XY]
         if { $L < $Lmin } {
            set Zmin $Z
         } elseif { $L > $Lmax } {
            set Zmax $Z
         } else { set OK 0 }
      }

      set dX [expr $SaTm(0) - $X]
      set dY [expr $SaTm(1) - $Y]
      set dZ [expr $SaTm(2) - $Z]
      set LoSBeG($I) [expr sqrt($dX * $dX + $dY * $dY + $dZ * $dZ)]
     
   } else { set LoSBeG($I) 0.0 }

   set OK 1
   set Z [expr -$SaTm(2)]
   while { $OK } {
      set tZ [ expr ($Z - $SaTm(2)) / $zH]
      set X  [expr $tZ * $xH +  $SaTm(0)]
      set Y  [expr $tZ * $yH +  $SaTm(1)]
      set XY [expr $X * $X + $Y * $Y + 1.0e-9]   
      set D  [expr sqrt($XY + $Z * $Z)]
      set L  [expr $D * $D * $D / $XY]
      if { $L > $Lmax } { 
         set OK 0
      } else { set Z [expr $Z * 1.5] } 
   }

   set OK 1
   set Zmax $Z
   set Zmin $MinZ
   while { $OK } {
      set Z  [expr ($Zmax + $Zmin) / 2.0]
      set tZ [ expr ($Z - $SaTm(2)) / $zH]
      set X  [expr $tZ * $xH +  $SaTm(0)]
      set Y  [expr $tZ * $yH +  $SaTm(1)]
      set XY [expr $X * $X + $Y * $Y + 1.0e-9]   
      set D  [expr sqrt($XY + $Z * $Z)]
      set L  [expr $D * $D * $D / $XY]
      if { $L < $Lmin } {
         set Zmin $Z
      } elseif { $L > $Lmax } {
         set Zmax $Z
      } else { set OK 0 }
   }

   set dX [expr $SaTm(0) - $X]
   set dY [expr $SaTm(1) - $Y]
   set dZ [expr $SaTm(2) - $Z]
   set LoSEnD($I) [expr sqrt($dX * $dX + $dY * $dY + $dZ * $dZ)]
}
