package provide EUVSim 1.0

# THIS procedure inverts an EUV image to obtain a solution for the He+
#    density in the geomagnetic equitorial plane and then uses the
#    inverted solution to produce a simulated EUV image which can be
#    compared to the original.
#
# INPUTS:
#
# OUTPUTS:
#        
# PROCEDURE RETURNS:
#

proc RunModel { } {
   global RtoD euvANS gIMG gHDM zImG lsImG gMl cDm HdM PHdM HaTm xSM ySM

   PlotStep SETUP
   set V1  [clock clicks -milliseconds]

# COMPUTE the lines of sight, the status for each line of sight, and
#    the column density associated with each line of sight

   LinesOfSight LOS
   LinesOfSight STAT
   LinesOfSight COLDEN

# TOTAL grids in the measured image matrix

   set TotGrids [expr $gIMG(4) * $gIMG(5)]
   set tG [expr $gHDM(4) * $gHDM(5)]

# TIME it takes to do the Line of Sight set up

   set V2  [clock clicks -milliseconds]
   TimeOut SETUP [expr ($V2 - $V1)/1000.0]
   set V1 $V2

# BUILD the zero solution grid.  This is a grid of the same dimensions as the
#   solution grid.  It marks the grids which must have a 0 column density 
#   based on the fact that they are used in a line of sight integration which
#   has a 0 solution.

   PlotStep "ZERO MATRIX"
   ZeroSol $TotGrids $euvANS(ZMax) $euvANS(ZStepSz) zImG

# SCRUB the zero solution matrix 

   ZeroSolScrub zImG 

# TIME it takes to form the Zero Solution Matrix

   set V2  [clock clicks -milliseconds]
   TimeOut ZERO [expr ($V2 - $V1)/1000.0]
   set V1 $V2
   
# PLOT the zero solution matrix if requested 

   if { $euvANS(zmDo) > 0 } { PutUpPlot zm zImG gHDM }

# SET variables which keep track of when either the raw or smoothed
#   solution matrices should be plotted.

   if { $euvANS(rmBg) < 0 } { 
      set bRaw [expr $euvANS(nIter) -1]
   } else { set bRaw $euvANS(rmBg) }
   if { $euvANS(rmEd) < 0 } { 
      set eRaw $euvANS(nIter)
   } else { set eRaw $euvANS(rmEd) }
   if { $euvANS(smBg) < 0 } { 
      set bSmo [expr $euvANS(nIter) -1]
   } else { set bSmo $euvANS(smBg) }
   if { $euvANS(smEd) < 0 } { 
      set eSmo $euvANS(nIter)
   } else { set eSmo $euvANS(smEd) }

   set NextRPlot $bRaw
   set NextSPlot $bSmo

# THIS is the 2D solution iteration loop.  
#
#   The first step is to initialize the solution matrix.  The solution 
#   matrix holds a density at each (L,Longitude) in the geomagnetic
#   equator corresponding the the minimum L value reached along the
#   instrument lines of sight.  To initialize the matrix we use a
#   a 1D density model of the form D = A10**(-.715*L) to first compute
#   the individual column densities and set the density as the model
#   density normalized by the ratio of the measured to computed column
#   density.  A 2D least squares filling algorithm is used to fill all
#   unfilled grids within the solution matrix
#
#   Iterations are then made using the solution matrix to provide the
#   densities used in computing the column densities.  The fixed locations
#   in the solution matrix are updated by the current value normalized
#   by the ratio of the measured column densities to computed column
#   densities.  The varience is computed after each iteration.  There 
#   is also a "HOT SPOT" check done after each iteration to make sure
#   that unstable elements in the solution matrix are suppressed.
#

   set HoldIter [expr $euvANS(nIter) - 2]
   set euvANS(PVar) 1.0e30

   set V1  [clock clicks -milliseconds]
   for { set nIter 0 } { $nIter < $euvANS(nIter) } { incr nIter } {

      PlotStep "ISTEP $nIter"

      if { $nIter == 0 } {
          set CnT [FirstGuess $TotGrids X Y V ]
          set euvANS(Var) 1.0e20
      } else { set euvANS(Var) [Iterate $CnT V ] }

      TUdataGrid $CnT 1 X X 1 Y Y V HdM Norm gHDM
      if { $nIter == 0 } { GridFillInputs HdM Norm gHDM fInfo }

      for { set I 0 } { $I < $tG } { incr I } {
         if { $zImG($I) == 0 } { set HdM($I) 0.0 ; set Norm($I) 1.0 }
      }

      if { $euvANS(hotSpot) == 1 }  { HotSpot HdM Norm gHDM }
      if { ($euvANS(rmDo) > 0) && (($nIter == $NextRPlot) \
               && ($nIter <= $eRaw)) } { 
         set euvANS(rmT1) "ITERATION $nIter"
         PutUpPlot rm HdM gHDM
         incr NextRPlot $euvANS(rmDt)
      }

      TUgridFill2D HdM gHDM Norm fInfo

      if { $euvANS(sdeSpeck) == 1 } {
         TUgridNoise DESPECKLE HdM gHDM $euvANS(sspeckN) $euvANS(sspMin) 0.0
      }

      if { ($euvANS(smDo) > 0) && (($nIter == $NextSPlot) \
                && ($nIter <= $eSmo)) } { 
         set pGn $euvANS(smPg)
         set euvANS(smT1) "ITERATION $nIter"
         PutUpPlot sm HdM gHDM
         incr NextSPlot $euvANS(smDt)
      }

      if { $nIter == $HoldIter } {
         set euvANS(PVar) $euvANS(Var)
         for { set gN 0 } { $gN < $tG } { incr gN } {
            set PHdM($gN) $HdM($gN)
         }
      }

      set V2  [clock clicks -milliseconds]
      TimeOut ITER [expr ($V2 - $V1)/1000.0] $nIter $euvANS(Var)
      set V1 $V2
   }

# Using the fits to produce the model image

   PlotStep "SIM IMAGE"
   ModelImg $TotGrids gHDM
   PlotStep "DONE"
   
   return $CnT
}
