package provide EUVSim 1.0

proc RadialPlotCuts { PiD } {
   global euvANS RtoD psImG gHDM gCUT PltInfo PI

   set pGn $euvANS(${PiD}Pg)
   if ![info exists pDone($pGn)] { set pDone($pGn) 0 }
   set nP [llength $euvANS(pW$pGn)]
   set cN [lindex $euvANS(pW$pGn) $pDone($pGn)]
   set sN [lindex $euvANS(sN$pGn) $pDone($pGn)]

#  Text size to use the canvas number

   set nP [llength $euvANS(pW$pGn)]
   if { $nP == 1 } { set tSz 12 } else { set tSz 8 }
   TextProp $tSz

#  Establish the canvas number

   SetScreen $sN $cN

   set MaxX [expr abs($euvANS(psBeg))] 

   SetAxis 5 PRIMARY HOLD HOLD HOLD HOLD HOLD HOLD HOLD $euvANS(rcSca) HOLD
   GenWindow 5 0.20 0.24 0.0 0.8 0.90 0.0 1.0 $euvANS(rcMin) 0.0 \
                                          $MaxX $euvANS(rcMax) 0.0

#  PUT up the colorbar.  Need to do this first so that we can get the 
#     coefficients in the color transfer table.
   
   set cInputs(pMIN) 0.0
   set cInputs(pMAX) 24.0
   set cInputs(pSCA) LINEAR
   set cInputs(PSIZE) HOLD:HOLD:$tSz:$tSz
   set cInputs(LABELS) MLT
   set cInputs(POS) ABSOLUTE
    
   set cW [ColorBar $euvANS(${PiD}Dp) 1.02 0.0 0. 1.05 1.0 0. cInputs cA cB]

   set Y(0) 0.0
   DefinePlot 5 5
   GPHwinReset 5
   WinClip 5 1
   set gCUT(4) [expr int([lindex $PltInfo(5,Pix) 0])]

#  PUT up the plot.  Input is in MLT, units of hours.  Conversion is
#    0 MLT = 180 degrees
#    6 MLT = 270 degrees
#   12 MLT =   0 degrees
#   18 MLT =  90 degrees

   set bP $euvANS(rcBg)
   set eP $euvANS(rcEd)
   set dA $euvANS(rcDt)
   set cAng 0.1
   for { set hR $bP } { $hR < $eP } { set hR [expr $hR + $dA] } {
      set gL [expr 360.0 * fmod($hR,24.0) / 24.0 + 180.0]
      set gL [expr fmod($gL,360.0)]
      if [string match PT $euvANS(SolGrid)] {
         if { $gL == 180.0 } { set nAng 179.95 }
         if { $gL > 180.0 } { set nAng [expr $nAng - 360.0] }
         set rA [expr $gL / $RtoD]
         set nP [TUgridCut psImG gHDM $rA $gHDM(2) $rA $gHDM(3) 100 XX YY ZZ 0]
      } else {
         set rA [expr $gL / $RtoD]
         set R  [expr ($gHDM(1) - $gHDM(0) + $gHDM(3) - $gHDM(2)) / 2.0]
         set Xa [expr 1.0 * cos($rA)]
         set Ya [expr 1.0 * sin($rA)]
         set Xb [expr $R * cos($rA)]
         set Yb [expr $R * sin($rA)]
         set nP [TUgridCut psImG gHDM $Xa $Ya $Xb $Yb 100 XX YY ZZ 0]
         for { set I 0 } { $I < $nP } { incr I } {
            set YY($I) [expr sqrt($XX($I) * $XX($I) + $YY($I) * $YY($I))]
         }
      }
      set CoLoR [GetColor [expr fmod($hR,24.0)] cA]
      if { $CoLoR == 0 } { set CoLoR 1 }
      TUdataGrid $nP 1 YY YY $nP Y Y ZZ cGrid Norm gCUT
      TUgridFill1D cGrid gCUT X HF -1 1
      Plot2D $euvANS(${PiD}Dp) Xb Yb AB cGrid -1 0 LINE [list $CoLoR <= 0.0]
      set cAng [expr $cAng + $dA]
   }
   PlotOutlines $euvANS(${PiD}Dp) [list Re 1.0 "He+ /cc" 1.0]
   update
}
