package provide EUVSim 1.0

# THIS procedure produces the plots of all the meshes

proc PutUpPlot { PiD Grid gInfo} {
   global GphInfo euvANS env pDone Yr Dy Msec

   upvar $Grid  G
   upvar $gInfo gI

   set pGn $euvANS(${PiD}Pg)
   if ![info exists pDone($pGn)] { set pDone($pGn) 0 }
   set nP [llength $euvANS(pW$pGn)]
   set cN [lindex $euvANS(pW$pGn) $pDone($pGn)]
   set sN [lindex $euvANS(sN$pGn) $pDone($pGn)]
   set pN $euvANS(${PiD}Dp)
   lappend euvANS(UsedScr) [list $PiD $cN]

#  Text size to use the canvas number

   set nP [llength $euvANS(pW$pGn)]
   if { $nP == 1 } { 
      set tSz [expr int(16 * $euvANS(MaxPix) / 720)] 
      set lSz [expr int(14 * $euvANS(MaxPix) / 720)] 
   } else { 
      set tSz [expr int(12 * $euvANS(MaxPix) / 720)]
      set lSz [expr int(10 * $euvANS(MaxPix) / 720)]
   }
   TextProp $tSz

#  Establish the canvas number

   SetScreen $sN $cN
   GenWindow 1 0.0 0.0 0.0 1.0 1.0 0.0  0. 0. 0. 1. 1. 0. XY

   PlotColor HOLD $GphInfo(bColor) $GphInfo(bColor)
   Box bW$sN 0.0 0.0 0.0 1.0 1.0 0.0
   PlotColor HOLD $GphInfo(lColor) OFF

#  Set up the colorbar parameters.
   
   set cInputs(pMIN) $euvANS(${PiD}Min)
   set cInputs(pMAX) $euvANS(${PiD}Max)
   if { $euvANS(${PiD}Sca) == 0 } {
      set cInputs(pSCA) LINEAR
      set cInputs(PFMTS) HOLD:HOLD:%.1f
   } else { 
      set cInputs(pSCA) LOG 
      set cInputs(PFMTS) HOLD:HOLD:expon
   }
   set cInputs(POS) ABSOLUTE
   set cInputs(PSIZE) HOLD:HOLD:$lSz:$lSz
   set cInputs(LABELS) $euvANS(${PiD}CbL)
    
#  PUT up the plot and colorbar.

   if [string match eq $PiD] {
      if { $euvANS(eqDo) == 1 } { 
          set pPiD eqxy
      } else { set pPiD eqpt }
   } else {
      if [string match XY $euvANS(SolGrid)] {
          set pPiD ${PiD}xy
      } else { set pPiD ${PiD}pt }
   }

   switch -exact -- $pPiD {
      rmpt -
      smpt -
      zmpt -
      rmxy -
      smxy -
      zmxy   {
         if [string match XY $euvANS(SolGrid)] {
            SqWindow $pN 0.15 0.20 0.0 0.60 $gI(1) $gI(3) 0. \
                                                   $gI(0) $gI(2) 0.
         } else {
            GenWindow $pN 0.20 0.20 0.0 0.80 0.80 0.0 $gI(0) $gI(2) 0. \
                                                      $gI(1) $gI(3) 0.
         }
         DefinePlot $pN $pN
         set cW [ColorBar $pN 1.02 0.0 0. 1.05 1.0 0. cInputs cA cB]
         TUgridInfo 30 gI xC
         TUgridInfo 31 gI yC
         Plot3D $pN Xb Yb xC yC G MANUAL gI cA
      }
      sipt -
      mipt -
      lspt -
      rapt -
      sixy -
      mixy -
      lsxy -
      raxy  { 
         GenWindow $pN .20 .20 0. .80 .80 0. $gI(0) $gI(2) 0. $gI(1) $gI(3) 0.
         DefinePlot $pN $pN
         set cW [ColorBar $pN 1.02 0.0 0. 1.05 1.0 0. cInputs cA cB]
         TUgridInfo 30 gI xC
         TUgridInfo 31 gI yC
         Plot3D $pN Xb Yb xC yC G MANUAL gI cA
      }
      eqpt -
      pspt -
      rgpt -
      agpt  { 
         SqWindow $pN 0.15 0.20 0.0 0.60 \
                            $euvANS(${PiD}Beg) $euvANS(${PiD}Beg) 0. \
                            $euvANS(${PiD}End) $euvANS(${PiD}End) 0.
         DefinePlot $pN $pN
         set cW [ColorBar $pN 1.02 0.0 0. 1.05 1.0 0. cInputs cA cB]
         set oPs(0) 1
         PolarPlot $pN Dummy Dummy G gI oPs cA 
      }
      psxy -
      agxy -
      rgxy -
      eqxy  { 
         SqWindow $pN 0.15 0.20 0.0 0.60 \
                            $euvANS(${PiD}Beg) $euvANS(${PiD}Beg) 0. \
                            $euvANS(${PiD}End) $euvANS(${PiD}End) 0.
         DefinePlot $pN $pN
         set cW [ColorBar $pN 1.02 0.0 0. 1.05 1.0 0. cInputs cA cB]
         TUgridInfo 30 gI xC
         TUgridInfo 31 gI yC
         Plot3D $pN Xb Yb xC yC G MANUAL gI cA
      }
   }

   set euvANS(eqXL) $euvANS(psXL)
   set euvANS(eqYL) $euvANS(psYL)

   PLTinfoChg $pN ALL NUMBERS NSIZE $lSz
   PLTinfoChg $pN ALL NUMBERS TSIZE $lSz
   PlotOutlines $pN [list $euvANS(${PiD}XL) 1.0 \
                          $euvANS(${PiD}YL) 1.0 "" 1.0 "" 1.0] ""
   update

   set GphInfo(curWin) bW$sN
   set yT [GPHtextLen A Y]
   TextProp [expr $tSz - 2]
   TexT bW$sN 0.5 0.94 0.0 center $euvANS(${PiD}T1) $GphInfo(White)
   set Y [expr .94 - 1.5 * $yT]
   TexT bW$sN 0.5 $Y 0.0 center $euvANS(${PiD}T2) $GphInfo(White)
   TextProp [expr $tSz - 2]
   TexT bW$sN 0.98 0.03 0.0 left $euvANS(${PiD}Name) $GphInfo(White)

   switch -exact -- $PiD {
      ag -
      rg -
      ps {
         PlotColor HOLD $GphInfo(Yellow) OFF
         Line $pN 0.0 0.0 0.0 1.0 0.0 0.0
         PlotColor HOLD $GphInfo(White) OFF
         if { $euvANS(kP) >= 0.0 } {
            set NpP [expr -.46666 * $euvANS(kP) + 5.76]
            Arc $pN 0.0 0.0 0.0 $NpP 0.0 360.0 1 0 1.0
         }
      }
   }

   incr pDone($pGn)
   update
}
