package provide EUVSim 1.0

proc MultiSimPlot { } {
   global msANS GphInfo WinInfo SySCmDs PI GPHWindow GPHRender

# Number of rows and columns of plots

   set nR  $msANS(pRows)
   set nC  $msANS(pCols)

# NEED a directory and source for each of the files to be plotted

   set nDir [llength $msANS(pDir)]
   set pFile ""
   set pSrc ""
   set pGz ""
   set SrcS(H) 0 ; set SrcS(M) 0 ; set SrcS(E) 0
   for { set I 0 } { $I < $nR } { incr I } {
      for { set J 0 } { $J < $nC } { incr J } {
         set DeF r${I}c${J} 
         set fName $msANS($DeF)
	 set Head [string range $fName 0 3]
         switch -exact -- $Head {
            MENA    { set TaiL ""     ; lappend pSrc MENA ; set SrcS(M) 1 }
            HENA    { set TaiL ""     ; lappend pSrc HENA ; set SrcS(H) 1 }
            default { set TaiL ".sim" ; lappend pSrc EUV  ; set SrcS(E) 1 } 
         }
         append fName $TaiL
	 set fOK 0 ; set K 0 ; set Gz 0
	 while { !$fOK && ($K < $nDir) } { 
	    set pDir [lindex $msANS(pDir) $K]
            set pF [file join $pDir $fName]
            if [file exists $pF] {
	       set fOK 1
            } else {
               set gSimFile ${pF}.gz
               if [file exists $gSimFile] {
                  set Gz 1
                  exec $SySCmDs(gzip) -df $gSimFiles
                  set fOK 1
               }
            } 
	    incr K
         }
         if { !$fOK } {
	    puts stderr "NO FILE $pF"
	    exit
	 } else { lappend pFile $pF ; lappend pGz $Gz }

      }
   }


# SET up the colorbars.  

   if [string match VERTICAL $msANS(cLoc)] {
      set LaBa(E) "He+ Den"  ; set LaBb(E) "(/cc)"
      set LaBa(M) "M Ion Flux" ; set LaBb(M) "(#/cm-s-sr-keV)"
      set LaBa(H) "H Ion Flux" ; set LaBb(H) "(#/cm-s-sr-keV)"
   } else {
      set LaBa(E) "He+ Density (/cc)"
      set LaBa(M) "MENA Ion Flux (#/cm-s-sr-keV)"
      set LaBa(H) "HENA Ion Flux (#/cm-s-sr-keV)"
   }

   set cList [list H M E]
   set nCb [expr $SrcS(E) + $SrcS(H) + $SrcS(M)]
   if { [expr $nCb %2] == 0 } {
      set nCb [expr int($nCb/2)]
   } else { set nCb [expr int($nCb/2) + 1] }

   set CB 0
   set sA p ; set sB PRIMARY ; set sC P ; set sD PRI
   for { set I 0 } { $I < 3 } { incr I } {
      set Src [lindex $cList $I]   
      if $SrcS($Src) {
         set caInputs(${sA}MIN) $msANS(cMin$Src)
         set caInputs(${sA}MAX) $msANS(cMax$Src)
         set caInputs(${sA}SCA) $msANS(cSca$Src)
	 set caInputs($sB) ON:ON:ON:ON
	 if [string match LOG $caInputs(${sA}SCA)] {
	    set caInputs($sB) ON:ON:ON:ON
	    set caInputs(${sC}FMTS)   HOLD:HOLD:%.0e
         } else { set caInputs(${sC}FMTS)   HOLD:HOLD:%.2e }
	    if [string match VERTICAL $msANS(cLoc)] {
	    append caInputs(LABELS) "" 
	    if [string match LOG $caInputs(${sA}SCA)] {
               set caInputs(${sC}FMTS)   HOLD:HOLD:expon
            }
	 } else { append caInputs(LABELS) $LaBa($Src) }
	 if { $sA == "p" } { append caInputs(LABELS) : }
	 incr CB
	 if { $CB == 1 } {
	     set sA s ; set sB SECONDARY ; set sC S ; set sD SEC
         } else { break }
      }
   }

# Set up the plots

   set bR [expr ($nR - 1) * $nC ] 
   set nPlots [expr $nR * $nC]

   set xB  $msANS(pMin)
   set yB  $msANS(pMin)
   set xE  [expr $msANS(pMin) - 2.0 * $xB]
   set yE  [expr $msANS(pMin) - 2.0 * $yB]

   set X [winfo screenwidth .]
   set Y [winfo screenheight .]
   if { $X > $Y } {
      set MaxPix [expr int($msANS(ZooM) * $Y)]
   } else { set MaxPix [ expr int($msANS(ZooM) * $X)] }

   if [string match VERTICAL $msANS(cLoc)] {
       set GphInfo(xScrL) $MaxPix
       set GphInfo(yScrL) [expr $MaxPix * 0.75]
   } else {
       set GphInfo(xScrL) [expr $MaxPix * 0.75]
       set GphInfo(yScrL) $MaxPix
   }

#      set GphInfo(xScrL) 800
#      set GphInfo(yScrL) 800

   GraphicsOn $msANS(dev) $msANS(ctbl) NOSWAP 
   if [string match VTK $msANS(dev)] { set VtK 1 } else { set VtK 0 }
   PlotColor HOLD 255 OFF
   set WinInfo(A,posFmt) 1
   SqWindow  A 0.0 0.0 0.0 1.0 0. 0. 0. 1.0 1.0 0.

   TextProp 12
   set cS [GPHtextLen A XY] 

   set xBase [expr 8.0 * [lindex $cS 0]]
   set yBase [expr 1.0 - 5.0 * [lindex $cS 1]]
   set xLen [expr 1.0 - 12.0 * [lindex $cS 0]]
   set yLen [expr 1.0 - 12.0 * [lindex $cS 1]]
   if { $xLen > $yLen } { set Len $yLen } else { set Len $xLen }

   if { $nC > $nR } {
      set dX [expr $Len / $nC]
      set dY [expr $Len / $nC]
   } else {
      set dX [expr $Len / $nR]
      set dY [expr $Len / $nR]
   }

   set wN 0
   for { set I 0 } { $I < $nR } { incr I } {
      set yT [expr $yBase - $I * $dY] 
      set yL [expr $yT - $dY]
      for { set J 0 } { $J < $nC } { incr J } {
         set xL [expr $xBase  + $J * $dX]
         set xT [expr $xL + $dX]
         set WinInfo($wN,corFmt) 1
         RelWindow $wN A $xL $yL 0.0 $xT $yT 0.0 $xB $yB 0.0 $xE $yE 0.0
         incr wN
      }
   }

   if [string match VERTICAL $msANS(cLoc)] {
      set ycB [expr $yBase + 2.0 * [lindex $cS 1] - $nR * $dY]
      set ycT [expr $yBase - 2.0 * [lindex $cS 1]]
      set xcB [expr $xBase + 5.0 * [lindex $cS 0] + $nC * $dX]
      set xcT [expr $xcB + 2.0 * [lindex $cS 0]]
   } else {
      set ycT [expr $yBase - 9.0 * [lindex $cS 1] - $nR * $dY]
      set ycB [expr $ycT - 2.0 * [lindex $cS 1]]
      set xcB [expr $xBase + 2.0 * [lindex $cS 0]]
      set xcT [expr $xBase - 2.0 * [lindex $cS 0] + $nC * $dX]
   }

   PlotColor HOLD HOLD 255

   set caInputs(WHITE)     NO
   set caInputs(LEV)       0.5:0.5
   set caInputs(FMT)       $msANS(cLoc)
   set caInputs(POS)       RELATIVE
   set caInputs(ANNOTATE)  YES
   set caInputs(AXIS)      YES
   set caInputs(PRIMARY)   TICMJ:TICMN:NUM:LABEL
   set caInputs(SECONDARY) TICMJ:TICMN:NUM:LABEL
   if $VtK {
      set caInputs(PSIZE)     HOLD:HOLD:24:24
      set caInputs(SSIZE)     HOLD:HOLD:24:24
   } else {
      set caInputs(PSIZE)     HOLD:HOLD:12:12
      set caInputs(SSIZE)     HOLD:HOLD:12:12
   } 

   set cB [ColorBar A $xcB $ycB 0.0 $xcT $ycT 0.0 caInputs cIb cIa]
   if [string match VERTICAL $msANS(cLoc)] {
      if $VtK {
         PLTinfoChg $cB Xt NUMBERS TSIZE 24
         PLTinfoChg $cB ALL NUMBERS NSIZE 24
      } else { PLTinfoChg $cB Xt NUMBERS TSIZE 12 }
      set nTList [list NONE NONE NONE NONE]
      PlotOutlines $cB [list "" 1 "" 1 $LaBa(E) 4.0] $nTList
      PlotOutlines $cB [list "" 1 "" 1 $LaBb(E) 2.0] $nTList
   }

   set pID 0
   for { set I 0 } { $I < $nR } { incr I } {
      for { set J 0 } { $J < $nC } { incr J } {
         set pN [expr $I * $nC + $J]
         set DeF r${I}c${J} 
         DefinePlot $pN $pN

	 set SrC   [lindex $pSrc $pID]
	 set Gz    [lindex $pGz $pID]
	 set pName [lindex $pFile $pID]

         switch -exact -- $SrC {
	    EUV {
#              set nP [ReadEUVInv $pName Xs Ys Ds iGI AnC]
               set nP [ReadEUVInv $pName Xs Ys iG iGI AnC]
#       set nP [expr $iGI(4) * $iGI(5)]
               PLTcolorMap $msANS(cMinE) $msANS(cMaxE) $msANS(cScaE) NO cIa
#       for { set I 0 } { $I < $nP } { incr I } {
#          set Gx($I) [expr $Ys($I) * cos($Xs($I))]
#   	  set Gy($I) [expr $Ys($I) * sin($Xs($I))]
#       }
#       set AnC(FORMAT) XY
#       set iGI(10) NEW:ADD:END
#       set iGI(4) 150
#       set iGI(5) 150
#       set iGI(3) [expr double($iGI(3))]
#       set iGI(0) [expr -$iGI(3)]
#       set iGI(1) $iGI(3)
#       set iGI(2) [expr -$iGI(3)]
#       set iGI(15) NO
#       set iGI(15) NO

#       set sI(0) 1 ; set sI(1) 5 ; set sI(2) 4
#       set sI(3) 2 ; set sI(4) 1 ; set sI(5) 0
#       set sI(6) 0 ; set sI(7) 0 ; set sI(8) -2

#       TUdataGrid $nP 1 Gx Gx 1 Gy Gy Ds iG gNorM iGI
#       TUgridFill2D iG iGI "" sI
            }
	    MENA {
	       set AnC(FORMAT) XY
	       set iGI(0)  $xB         ; set iGI(1) $xE      ; set iGI(4) 70
               set iGI(2)  $yB         ; set iGI(3) $yE      ; set iGI(5) 70
               set iGI(6)  BAND        ; set iGI(7) BAND 
               set iGI(8)  COLUMN      ; set iGI(9) IGNORE   
	       set iGI(10) NEW:ADD:END
               set iGI(11) 0.0         ; set iGI(12) -1.0e31
               set iGI(13) -1.0e30     ; set iGI(14) 1.0e30
               set iGI(15) NO          ; set iGI(16) NO
	       set nP [IonInvRead $pName Xs Ys Ds AnC 1 xX yY UA XY]
	       TUdataGrid [lindex $nP 2] 1 Xs xX 1 Ys yY Ds iG gNorM iGI
               PLTcolorMap $msANS(cMinM) $msANS(cMaxM) $msANS(cScaM) NO cIa
	    }
	    HENA {
	       set AnC(FORMAT) PT
	       set gI(0)  [expr -$PI] ; set gI(1) $PI
               set gI(2)  1.2         ; set gI(3) 10.8
               set gI(6)  BAND        ; set gI(7) BAND 
               set gI(8)  COLUMN      ; set gI(9) IGNORE   
	       set gI(10) NEW:ADD:END
               set gI(11) 0.0         ; set gI(12) -1.0e31
               set gI(13) -1.0e30     ; set gI(14) 1.0e30
               set gI(15) YES         ; set gI(16) NO
	       set nP [IonInvRead $pName Xs Ys Ds AnC 1 xX yY APL]
               set gI(4) [lindex $nP 0]
               set gI(5) [lindex $nP 1]
               TUdataGrid [lindex $nP 2] 1 Xs xX 1 Ys yY Ds G gNorM gI
               TUgridGrow G gI iG iGI 3 3
               PLTcolorMap $msANS(cMinH) $msANS(cMaxH) $msANS(cScaH) NO cIa
	    }
         }

# REGZIP if unzipped

         if { $Gz == 1 } { exec $SySCmDs(gzip) -f $pName }

# FORM time 

         scan $AnC(TIME) "%4s%3s%2s%2s%2s%s" fY fD fH fM fS Rest
         set fD [string trimleft $fD "0"] 
         set fH [string trimleft $fH "0"] 
         if { [string length $fH] == 0 } { set fH 0 }
         set fM [string trimleft $fM "0"] 
         if { [string length $fM] == 0 } { set fM 0 }
         set fS [string trimleft $fS "0"] 
         if { [string length $fS] == 0 } { set fS 0 }

         set Tm [format "%d %03d %02d:%02d" $fY $fD $fH $fM] 

# DECIMATE before SMOOTH

         set nE [array size iGI]
         for { set K 0 } { $K < $nE} { incr K } { set oGI($K) $iGI($K) }

         if { $msANS(pDec) > 1 } {
            set oGI(4) [expr int($oGI(4) / $msANS(pDec))]
            set oGI(5) [expr int($oGI(5) / $msANS(pDec))]
            TUgridReGrid REGRID iG iGI oG oGI NorM END
         } else { TUgridMath iG DUP iG oG iGI}


# SMOOTH it

         set fE ""
         switch -exact -- $msANS(pSm) {
            3x3L {
               set fE [list 1.0  2.0  1.0 \
                            2.0  4.0  2.0 \
                            1.0  2.0  1.0 ]
            }
            3x3H {
               set fE [list -1.0  -1.0  -1.0 \
                            -1.0   9.0  -1.0 \
                            -1.0  -1.0  -1.0 ]
            }
            5x5L {
               set fE [list 1.0  1.0   1.0  1.0  1.0 \
                            1.0  4.0   4.0  4.0  1.0 \
                            1.0  4.0  12.0  4.0  1.0 \
                            1.0  4.0   4.0  4.0  1.0 \
                            1.0  1.0   1.0  1.0  1.0 ]
             }
            5x5H {
               set fE [list  0.0  -1.0   -1.0  -1.0   0.0 \
                            -1.0   2.0   -4.0   2.0  -1.0 \
                            -1.0  -4.0   13.0  -4.0  -1.0 \
                            -1.0   2.0   -4.0   2.0  -1.0 \
                             0.0  -1.0   -1.0  -1.0   0.0 ]
            }
         }

# NORMALIZE the smoothing mask

         set nE [llength $fE]
         if { $nE > 0 } { 
            set SuM 0.0
            for { set K 0 } { $K < $nE } { incr K } { 
               set F($K) [lindex $fE $K] 
               set SuM [expr $SuM + abs($F($K))] 
            }
            for { set K 0 } { $K < $nE } { incr K } { 
               set F($K) [expr $F($K) / $SuM] 
            }

# Smooth the grid

            set sOp(0) 0
            TUgridFilter 2DFILTER oG oGI sOp F
         }

         if [string match PT $AnC(FORMAT)] {
            set oPs(0) 1
            PolarPlot  $pN PP PP oG oGI oPs cIa
         } else {
            TUgridInfo 30 oGI xC
            TUgridInfo 31 oGI yC

            if $VtK { 
	       set oGI(PF) ELEVATE 
	       set GphInfo(vtkSFac) 0.75
	    }
            Plot3D $pN Xb Yb xC yC oG MANUAL oGI cIa
         }
	 TexT $pN 0.0 0.0 0.0 center [string index $SrC 0] $GphInfo(White)
        
         if $VtK {
            PLTinfoChg $pN ALL NUMBERS NSIZE 24
            PLTinfoChg $pN ALL NUMBERS TSIZE 24
            PLTinfoChg $pN Xt NUMBERS TSIZE 24
         } else {
            PLTinfoChg $pN ALL NUMBERS NSIZE 12
            PLTinfoChg $pN ALL NUMBERS TSIZE 12
            PLTinfoChg $pN Xt NUMBERS TSIZE 12
	 }
         PLTaxisRec $pN Xt NONE AXIS -1.5 0.0 center $Tm
         if { $pN == $bR } { 
            PlotOutlines $pN [list "X SM" 1 "Y SM" 1] [list BOT BOT BOTH BOTH]
         } else {
            PlotOutlines $pN [list "" 1 "" 1] [list NONE NONE BOTH BOTH]
         }
         update
	 incr pID
      }
   }

   ShowScreen
}
