package provide EUVSim 1.0

proc MsGUI {  } {
  global msANS env Prefs

# READ in the preference file

   GUIprefsRead

# LETS make the labels in the menu bold

   set LFonT [list fixed $Prefs(FontSize) bold]

# LAY out the window names for the GUI frame structure

   set bW .msGUI

   if { [winfo exists $bW] == 0 } {
      toplevel $bW
      wm title . "MULTI SIM PLOTS"
      wm withdraw .

      set WiNs [list cmd top menu opts]
      set Frms [list a b c d]
      set nF [llength $Frms]

      for { set I 0 } { $I < $nF } { incr I } {
          set W $bW.[lindex $WiNs $I]
          set W[lindex $Frms $I] $W
          GUIFrame $W -1 pack|top||both
      }

      GUIbuttonPush $Wa.quit QUIT pack|right "exit"    6
      GUIbuttonPush $Wa.run  RUN  pack|left  "MultiSimPlot"   6

      for { set I 1 } { $I < $nF } { incr I } {
          set Wl $bW.[lindex $WiNs $I].left
          set Wr $bW.[lindex $WiNs $I].right
          set W[lindex $Frms $I]l $Wl
          set W[lindex $Frms $I]r $Wr
          GUIFrame $Wl 0 pack|left|w
          GUIFrame $Wr 0 pack|right|e
      }

# OUTPUT DEVICE

      GUILabel $Wbl.lab1 "Output To" c grid|0|0 0 0 "" $LFonT
      set Ops [GUdevOpts]
      set Lab [lindex [split [lindex $Ops 0] '|'] 0]
      set msANS(dev) [lindex [split [lindex $Ops 0] '|'] 1]
      GUIbuttonMenu $Wbl.dev $Lab grid|1|0 $Ops  \
           "GUIoptsProcess $Wbl.dev msANS(dev) ALT " 6

# COLOR TABLE

      set CtOps [GUctblOpts]
      if ![info exists msANS(ctbl)] {
         set msANS(ctbl) [lindex [split [lindex $CtOps 0] '|'] 1 ]
         set CtLab [lindex [split [lindex $CtOps 0] '|'] 0 ]
      } else {
         set CtLab ""
         set nCt [llength $CtOps]
         for { set I 0 } { $I < $nCt } { incr I } {
            set AlT [lindex [split [lindex $CtOps $I] '|'] 1 ]
            if {[string compare $AlT $msANS(ctbl)] == 0 } {
               set CtLab [lindex [split [lindex $CtOps $I] '|'] 0 ]
               break
            }
         }
         if { [string length $CtLab] == 0 } {
            set msANS(ctbl) [lindex [split [lindex $CtOps 0] '|'] 1 ]
            set CtLab [lindex [split [lindex $CtOps 0] '|'] 0 ]
         }
      }


      GUILabel $Wbl.lab2 "ColorTable" c grid|0|1 0 0 "" $LFonT
      GUIbuttonMenu $Wbl.ctbl $CtLab grid|1|1 $CtOps  \
           "GUIoptsProcess $Wbl.ctbl msANS(ctbl) ALT " 6

      set Row 0
      GUILabel $Wcl.lmif "Input Menu File"  c grid|$Row|0|e 0 0 "" $LFonT
      GUIboxEntry $Wcl.mif grid|$Row|1 40 msANS(miFile)
      GUIbuttonPush $Wcl.load  LOAD  grid|$Row|2|e "MsRead"
      incr Row
      GUILabel $Wcl.lmof "OutPut Menu File" c grid|$Row|0|e 0 0 "" $LFonT
      GUIboxEntry $Wcl.mof grid|$Row|1 40 msANS(moFile) 
      GUIbuttonPush $Wcl.save  SAVE grid|$Row|2|e "MsSave"

      set Row 0
      GUIblankRow $Wdl $Row 1.0
      incr Row

      GUILabel $Wdl.lcmin "Min"   c grid|$Row|1|ew 0 0 "" $LFonT
      GUILabel $Wdl.lcmax "Max"   c grid|$Row|2|ew 0 0 "" $LFonT
      GUILabel $Wdl.lcsca "Scale" c grid|$Row|3|ew 0 0 "" $LFonT
      GUILabel $Wdl.lcloc "Location" c grid|$Row|4|ew||2 0 0 "" $LFonT

      set oPs [list LINEAR|0 LOG|1]
      set CbOps [list VERTICAL|0 RHORIZONTAL|1 LHORIZONTAL|2]
      incr Row
      GUILabel $Wdl.lcbh "HENA ColorBar" w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wdl.cminh grid|$Row|1 8 msANS(cMinH)
      GUIboxEntry $Wdl.cmaxh grid|$Row|2 8 msANS(cMaxH)
      GUIbuttonToggle $Wdl.cscah $msANS(cScaH) grid|$Row|3|ew $oPs \
                             "GUIoptsToggle $Wdl.cscah msANS(cScaH) PRI " 6
      GUIbuttonMenu $Wdl.cloc $msANS(cLoc) grid|$Row|4|||2 $CbOps  \
           "GUIoptsProcess $Wdl.cloc msANS(cLoc) PRI " 6

      incr Row
      GUILabel $Wdl.lcbm "MENA ColorBar" w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wdl.cminm grid|$Row|1 8 msANS(cMinM)
      GUIboxEntry $Wdl.cmaxm grid|$Row|2 8 msANS(cMaxM)
      GUIbuttonToggle $Wdl.cscam $msANS(cScaM) grid|$Row|3|ew $oPs \
                             "GUIoptsToggle $Wdl.cscam msANS(cScaM) PRI " 6

      incr Row
      GUILabel $Wdl.lcbe "EUV ColorBar" w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wdl.cmine grid|$Row|1 8 msANS(cMinE)
      GUIboxEntry $Wdl.cmaxe grid|$Row|2 8 msANS(cMaxE)
      GUIbuttonToggle $Wdl.cscae $msANS(cScaE) grid|$Row|3|ew $oPs \
                             "GUIoptsToggle $Wdl.cscae msANS(cScaE) PRI " 6

      incr Row
      GUIblankRow $Wdl $Row 1.0
      incr Row

      GUILabel $Wdl.lzm "Zoom"   w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wdl.pzm grid|$Row|1 8 msANS(ZooM)

      incr Row
      GUILabel $Wdl.lpmn "MinR"   w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wdl.pmn grid|$Row|1 8 msANS(pMin)

      incr Row
      GUILabel $Wdl.lpdc  "Decim"  w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wdl.pdc grid|$Row|1 8 msANS(pDec)

      set Ops [list NO|0 3x3L|1 5x5L|2 3x3H|3 5x5H|4]

      incr Row
      GUILabel $Wdl.lbsm  "Filter" w grid|$Row|0|w 0 0 "" $LFonT
      GUIbuttonMenu $Wdl.psm $msANS(pSm) grid|$Row|1|||2 $Ops  \
           "GUIoptsProcess $Wdl.psm msANS(pSm) PRI " 6

      incr Row
      GUIblankRow $Wdl $Row 1.0
      incr Row
      
      GUILabel $Wdl.lrow "Rows" c grid|$Row|1|ew 0 0 "" $LFonT
      GUILabel $Wdl.lcol "Cols" c grid|$Row|2|ew 0 0 "" $LFonT
      incr Row
      GUILabel $Wdl.lpm "Plot Matrix" w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wdl.row grid|$Row|1 8 msANS(pRows) 
      GUIboxEntry $Wdl.col grid|$Row|2 8 msANS(pCols) 
      incr Row
      GUILabel $Wdl.ldir "File Directorys" w grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wdl.dir grid|$Row|1|||4 32 msANS(pDir) 
      incr Row

      GUIblankRow $Wdl $Row 1.0

      incr Row
      GUILabel $Wdl.pdlab "Plot Definitions"  w grid|$Row|0|w 0 0 "" $LFonT

      incr Row
      GUIblankRow $Wdl $Row 1.0


      incr Row
      set msANS(pGridRow) $Row
      for { set I 0 } { $I < $msANS(pRows) } { incr I } {
         GUILabel $Wdl.r${I}lab "Row $I"  w grid|$Row|0|w
         set Col 1
         for { set J 0 } { $J < $msANS(pCols) } { incr J } {
            set DeF r${I}c${J}
            GUIboxEntry $Wdl.$DeF grid|$Row|$Col|||2 14 msANS($DeF)
            incr Col 2
         }
         incr Row
      }
   }
   update
   bind  .msGUI.menu.left.mif <Return> \
                       { .msGUI.menu.left.mof delete 0 end ; \
                         .msGUI.menu.left.mof insert end "$msANS(miFile)"}

   bind  .msGUI.opts.left.row <Return>  {  ChgGUIpGrid }
   bind  .msGUI.opts.left.col <Return>  {  ChgGUIpGrid }
}
