package provide EUVSim 1.0

#  This procedure produces an image from the model count rate function.
#  This is done in the following manner.  The column density is computed
#  along each line if sight with the density at each L being given by
#  A*V where A is a constant and V is the output of the polynomial fit
#  returned from HeFit.  Then the computed column density at each pixel
#  is normalized to the image intensity to get A which is then the necessary
#  scaling factor taking the C(L) relationship to column density.  The
#  image is produced using the average or all computed A's.
#
#  The column density is essentially the volume integral over the emitters
#  (which is taken to be the total He density within the column).  The
#  number of emitters which actually contribute to the signal is the
#  density divided by 4*PI*r**2 which is an isotropic emission.  This
#  reduces the volume integral to essentially a line integral.
#
#  The density is computed at discrete locations along the line of sight
#  and is assumed to varly linearly between computation locations so that
#  the density in the integration is 
#
#                 D = Ar + B
# 
#  D is computed from the fit determined from the EUV image
# 
#  THIS routine uses the best fit from the current and last iteration.
#    the best fit is always in HdM

proc ModelImg {nP mInfo} {
   global euvANS pStat siImG CurInfo pStat LoSBeG LoSEnD HdM PHdM gHDM

   upvar $mInfo mI 

   if { $euvANS(Var) <= $euvANS(PVar) } {
      set euvANS(prIter) $euvANS(nIter)
      set euvANS(prVar)  $euvANS(Var)
   } else {
      set euvANS(prIter) [expr $euvANS(nIter) - 1]
      set euvANS(prVar)  $euvANS(PVar)
      set tG [expr $gHDM(4) * $gHDM(5)]
      for { set gN 0  } { $gN < $tG } { incr gN  } { set HdM($gN) $PHdM($gN) }
   }

   set CurInfo(2) $mI(0)
   set CurInfo(3) $mI(2)
   set CurInfo(4) [expr abs(($mI(1) - $mI(0))) / $mI(4)]
   set CurInfo(5) [expr abs(($mI(3) - $mI(2))) / $mI(5)]
   set CurInfo(6) $mI(4)
   set CurInfo(7) $mI(5)

   for { set I 0 } { $I < $nP } { incr I } {
      set CurInfo(0) $I
      if { $pStat($I) == 1 } {
         set cDi [ColDen Func2D $LoSBeG($I) $LoSEnD($I) 1]
         set siImG($I) [expr $cDi * $euvANS(F30.4) / 1.89e19 ]
      } else { set siImG($I) 0.0 }
   }
}
