package provide EUVSim 1.0

proc MatrixUsage { nG dL nRC nPC Coef Mesh mInfo } {
   global ToRad Re

   upvar $Coef A
   upvar $Mesh dM
   upvar $mInfo mI

# SET up a few constants needed to navigate around the He Density Matrix 

   set TotElem [expr $mI(4) * $mI(5)]
   for { set I 0 } { $I < $TotElem } { incr I } { set dM($I) 0 }

   set IncX [expr abs(($mI(1) - $mI(0))) / $mI(4)]
   set IncY [expr abs(($mI(3) - $mI(2))) / $mI(5)]
   set nC [expr $nRC + $nPC + 2]

# LOOP over all of the grid values (line of sights)

   for { set I 0 } { $I < $nG } { incr I } {

# INITIALIZE the offsets into coefficient array

      set ToC [expr $I * (2 * $nC + 2)]
      set MinR $A($ToC)
      set MaxR $A([expr $ToC + 1])
 
      incr ToC 2
      set MinL(0) $A([expr $ToC + 0])
      set MinL(1) $A([expr $ToC + $nC])
      incr ToC 2

      set ToP [expr $ToC + $nRC]

# SINCE L is double valued along the line of sight there are two fits which
#    return Position as a function L.  The outer loop ensures that we look
#    at both, however, we need to consider at the fit if it was produced.

      for { set J 0 } { $J < 2 } { incr J ; incr ToC $nC ; incr ToP $nC } {
         if { ($MinL($J) > 1000.0) } { continue } 

# GET the Density, Position, and Longitude of the first L-Shell in the
#    summation.

         set L  $MinL($J)
         set Ra [TUpolyExp1D $L $nRC A $ToC]
         set mL [TUpolyExp1D $L $nPC A $ToP]

         set Y  [expr int(($L - $mI(2)) / $IncY) ]                      
         if { ($Y >= 0) && ($Y < $mI(5)) } { 
            set X [expr int(($mL - $mI(0)) / $IncX) ]                      
            if { $X <  0 } { set X [expr $mI(4) + $X] }
            set X [expr $X % $mI(4)]
            set Pix [expr int($Y * $mI(4) + $X)] 
            incr dM($Pix)
         }

# NOW loop over each succeeding L-Shell and integrate the density between
#    the current and the last.  This is a linear integration of density 
#    with respect to R.

         set L [expr $MinL($J) + $dL] 
         for { } {$L <= $mI(3)} {set L [expr $L + $dL]} { 
            set Rb [TUpolyExp1D $L $nRC A $ToC]
            set mL [TUpolyExp1D $L $nPC A $ToP]
            set Y  [expr int(($L - $mI(2)) / $IncY) ]                      
            if { ($Y >= 0) && ($Y < $mI(5)) } { 
               set X [expr int(($mL - $mI(0)) / $IncX) ]                      
               if { $X <  0 } { set X [expr $mI(4) + $X] }
               set X [expr $X % $mI(4)]
               set Pix [expr int($Y * $mI(4) + $X)] 
               incr dM($Pix)
            }
         }
      }
   }
}
