package provide EUVSim 1.0

proc MaskOptMenu { } {
   global euvANS env Prefs

# LETS make the labels in the menu bold and titles a little larger

   set LFonT [list fixed $Prefs(FontSize) bold]
   set TFonT [list fixed [expr $Prefs(FontSize) + 4] bold ]
   set HFonT [list fixed [expr $Prefs(FontSize) + 2] bold ]
   set tC #0F0FAF
   set lC #FFFFFF

   set aOpts [list NONE|0 TOP|1 BOT|2 LEFT|3 RIGHT|4 ]
   set Zones [list TOP BOT LEFT RIGHT]
   set zones [list Top Bot Left Right]

   set W  .giMASK
   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "EUV INVERSION MASK OPTIONS PAGE"
      wm withdraw $W

      set Wa .giMASK.top
      set Wb .giMASK.opts

      GUIFrame $Wa -1 pack|top||both
      GUIFrame $Wb -1 pack|top||both

      GUILabel $Wa.lab "MASK MENU" w pack|left 0 0 "" $TFonT
      GUIbuttonPush $Wa.close CLOSE pack|right "wm withdraw $W" 6

      set Row 0
      GUILabel $Wb.lact "INPUT" c grid|$Row|0|ew 0 0 $tC $HFonT
      set LaB [lindex [split [lindex $aOpts $euvANS(aSide)] "|"] 0]
      GUIbuttonMenu $Wb.active $LaB grid|$Row|1|e||2 $aOpts  \
                      "GUIoptsProcess $Wb.active euvANS(aSide) ALT " 6

      set pLABS [list "POINTS 0/1" "POINTS 2/3" "POINTS 4/5" \
                                 "POINTS 6/7" "POINTS 8/9" ]

      for { set K 0 } { $K < 4 } { incr K } {
         set zL [lindex $Zones $K]
         set iD [lindex $zones $K]

         incr Row
         GUIblankRow $Wb $Row 1.0
         incr Row

         GUILabel $Wb.l$iD $zL c grid|$Row|0|ew 0 0 $tC $HFonT
         GUIbuttonPush $Wb.al$iD "ADD LINES" grid|$Row|1|e "Trace $iD ADD" 6 
         GUIbuttonPush $Wb.rl$iD "DEL LINES" grid|$Row|2|e "Trace $iD DEL" 6 
         GUIbuttonPush $Wb.dp$iD "DEL PTS"   grid|$Row|3|e "RmZone $iD" 6 
         GUIbuttonPush $Wb.up$iD "UPDATE"    grid|$Row|4|e "UpZone $iD" 6 

         incr Row
         GUIblankRow $Wb $Row 1.0
         incr Row

         GUILabel $Wb.lxa$iD "X" c grid|$Row|1|ew 0 0 "" $LFonT
         GUILabel $Wb.lya$iD "Y" c grid|$Row|2|ew 0 0 "" $LFonT
         GUILabel $Wb.lxb$iD "X" c grid|$Row|3|ew 0 0 "" $LFonT
         GUILabel $Wb.lyb$iD "Y" c grid|$Row|4|ew 0 0 "" $LFonT

         for { set I 0 ; set J 0 } { $I < 5 } { incr I } { 
           set LaB [lindex $pLABS $I]
	   set tG  ${iD}$J
           GUILabel $Wb.tl${iD}tl$I $LaB c grid|$Row|0|ew 0 0 "" $LFonT
           GUIboxEntry $Wb.tx$tG grid|$Row|1 10 euvANS(${iD}X$J)
           GUIboxEntry $Wb.ty$tG grid|$Row|2 10 euvANS(${iD}Y$J)
           incr J
	   set tG  ${iD}$J
           GUIboxEntry $Wb.tx$tG grid|$Row|3 10 euvANS(${iD}X$J)
           GUIboxEntry $Wb.ty$tG grid|$Row|4 10 euvANS(${iD}Y$J)
	   incr J
           incr Row
         }
      }
   }
}
