package provide EUVSim_C 1.0

# THIS procedure computes various aspects of the the lines of sight for 
#    a measured image.  It also establishes where each line of sight 
#    crosses the SM equatorial plane and can set a status for each line.
#
# INPUTS:
#
#    Aspect:  What aspect of the line of sight computations to do
#        LOS:  Compute the lines of sight
#        STAT: Set the status or each line of sight
#
# OUTPUTS:
#        
# PROCEDURE RETURNS:
#

proc LoS { tG Nadir xInfo rM } {
   global RtoD HaTm TwoPI gIMG SaTm SaTmM lsImG gMl xSM ySM lsMnZ 

   upvar $xInfo xI
   upvar $rM r1T

puts stderr TCLCODE
   set C [expr $SaTm(0) * $SaTm(0) + $SaTm(1) * $SaTm(1)]
   set S [expr $SaTmM * $SaTmM]

   set HatOff 0
   for { set gN 0  } { $gN < $tG } { incr gN  } {

#  GET the EUV pixel elevation and satellite phase angle assocaiated with
#     this pixel

      TUgridInfo 20 gIMG rInfo $gN

#  COMPUTE a the look direction.  This is a unit vector along the line of
#    sight

      set Ang [expr $rInfo(3) / $RtoD + $Nadir] 
      set Ang [expr fmod($Ang, $TwoPI)]
      set cTh [expr cos($rInfo(2) / $RtoD)]

      set pHat(0) [expr cos($Ang) * $cTh]
      set pHat(1) [expr sin($Ang) * $cTh]
      set pHat(2) [expr sin($rInfo(2) / $RtoD)]

#  PRODUCE look directions in the SM reference frame  The look direction
#    is saved for each pixel as it is used in all later iterations.

      TUmatrixMath r1T * pHat Hat  3 3 3 1
      TUdataCT Hat GEI xI TmP1 SM
      set HaTm($HatOff) $TmP1(0) ; incr HatOff
      set HaTm($HatOff) $TmP1(1) ; incr HatOff
      set HaTm($HatOff) $TmP1(2) ; incr HatOff

# FIND the location of the look direction with the SM equatorial plane. This
#   is done by finding the SM location of the smallest L-Shell passed through
#   by the LOS.  This method allows for correct solution even when the
#   orbit is highly canted with respect to the SM equator.

      set AdotS [TUvecMath TmP1 DOT SaTm TmP1]
      set minR [expr sqrt($S - $AdotS * $AdotS) ]

# FIND the minimum L-shell along the line of sight.

      set B [expr $TmP1(0) * $SaTm(0) + $TmP1(1) * $SaTm(1)]
      set a [expr $TmP1(0) * $TmP1(0) + $TmP1(1) * $TmP1(1)]
      set b [expr 4.0 * $B - $a * $AdotS]
      set c [expr 3.0 * $C + 2.0 * $B * $AdotS - 2.0 * $a * $S]
      set d [expr 3.0 * $AdotS * $C - 2.0 * $B * $S]
      set rV [TUsolveCubic $a $b $c $d]
   
      if { [llength $rV] == 3 } { set EnD 3 } else { set EnD 1 }
      set minLs  1.0e20;
      for { set I 0 } { $I < $EnD } { incr I } {
         set rS [lindex $rV $I]
         if { $rS >= 0.0 } {
            set T1 [expr $rS * $rS  + 2.0 * $rS * $AdotS + $S]
            set T2 [expr $a * $rS * $rS + 2.0 * $rS * $B + $C]
            set tLs [expr $T1 * sqrt($T1) / $T2 ]
            if { $tLs < $minLs } { 
              set minLs $tLs 
              set minLsR $rS
            }
         }
      }

      if { $minLs < 100.0 } {
         set lsImG($gN) $minLs
         set lsMnZ($gN) [expr $TmP1(2) * $minLsR + $SaTm(2)]
         set X [expr $TmP1(0) * $minLsR + $SaTm(0)]
         set Y [expr $TmP1(1) * $minLsR + $SaTm(1)]
         set gMl($gN) [expr atan2($Y, $X)]
         set xSM($gN) [expr $minLs * cos($gMl($gN))]
         set ySM($gN) [expr $minLs * sin($gMl($gN))]
      } else {
         set lsImG($gN) 1000.0
         set lsMnZ($gN) 1000.0
         set gMl($gN) 400.0
         set xSM($gN) 400.0
         set ySM($gN) 400.0
      }
   }
}
