package provide EUVSim 1.0

# THIS procedure computes various aspects of the the lines of sight for 
#    a measured image.  It also establishes where each line of sight 
#    crosses the SM equatorial plane and can set a status for each line.
#
# INPUTS:
#
#    Aspect:  What aspect of the line of sight computations to do
#        LOS:  Compute the lines of sight
#        STAT: Set the status or each line of sight
#
# OUTPUTS:
#        
# PROCEDURE RETURNS:
#

proc LinesOfSight { Aspect } {
   global RtoD euvANS HaTm miImG Re TwoPI gIMG gHDM \
          Yr Dy Msec SaT SuN SpiN SaTm SaTmM lsImG gMl cDm pStat \
          HdM PHdM xSM ySM lsMnZ LoSEnD LoSBeG

   set TotGrids [expr $gIMG(4) * $gIMG(5)]
  
   switch -exact -- $Aspect {
      LOS {

# ESTABLISH xInfo matrix used in coordinate system transformations

         TUtimeJulian $Yr(0) $Dy(0) $Msec(0) xInfo 1

# BUILD the rotation matrix which will rotate the satellite spin axis to 
#    be parallel to the GCI Z axis.  Also get its transpose to rotate
#    back into the native orientation.

         set Phi   [expr atan2($SpiN(1), $SpiN(0)) * $RtoD + 90.0]
         set XY    [expr sqrt ($SpiN(0) * $SpiN(0) + $SpiN(1) * $SpiN(1))]
         set Theta [expr atan2 ($XY, $SpiN(2)) * $RtoD ]
         set Psi [expr -$Phi]

         TUmatrixRot $Phi $Theta $Psi R1 EULER
         TUmatrixMath R1 TRANSPOSE R1 r1T 3 3 3 3

#  ROTATE the satellite so that its spin axis is || to the GCI +z axis.  
#    Subtract the Earth's position from the rotated vector.  This places
#    the satellite at the origin.

         TUmatrixMath R1 * SaT rE 3 3 3 1

#  GET the satellite position in SM coordinates in units of Re

         set TmP(0) $Re
         TUdataCT SaT GEI xInfo SaTm SM
         TUvecMath SaTm / TmP SaTm 0 0 0 3 1
         set SaTmM [TUvecMath SaTm MAG SaTm SaTm]

#  COMPUTE the nadir angle (this is the spin angle at which the XZ plane
#    of the satellite contains the Earth.  The negative sign is used
#    to translate the Earth to the origin for the computation.
   
         set Nadir [expr atan2(-$rE(1), -$rE(0))]

# NOW to the loop.  There is one loop over each pixel in the constructed
#    EUV image.  HatOff is the counter used for storing the unit vector 
#    along the LOS 

         LoS $TotGrids $Nadir xInfo r1T
      }
      STAT {

# We only need to consider a pixel if
#   1. The minimum R value reached along the line of sight indicated that
#      it does not strike the Earth (within some tolerance)
#   
#   2. The minimum L-Shell along the line of sight is less than the maximum
#      L-Shell kept within the solution matrix

         set MinL $euvANS(lowestR)
         set MaxL $euvANS(lSLim)
         for { set gN 0  } { $gN < $TotGrids } { incr gN  } {
            if { ($lsImG($gN) > $MinL) && ($lsImG($gN) <= $MaxL) } { 
               set pStat($gN) 1 
               SetLosEnds $gN $MaxL .1 $lsMnZ($gN)
            } else { 
               set lsImG($gN) 100.0
               set pStat($gN) -1 
            }
         } 
      }
      COLDEN {

# COMPUTE the factor which takes EUV measurements to He column density
#   and then set the column density associated with each measured pixel

         set Fac [expr 1.89e19 / $euvANS(F30.4)]
         for { set gN 0  } { $gN < $TotGrids } { incr gN  } {
            if { $miImG($gN) > 0.0 } {
               set cDm($gN) [expr $miImG($gN) * $Fac ]
            } else { set cDm($gN) 0.0 }
         }
      }
   }
}
