package provide EUVSim 1.0

proc GridSet { State Comp iD } {

   global euvANS env

   set bW .giINFO.opts.left

   set Wc $bW.p${Comp}${iD}
   set EnDs [list grid wide beg end]
   set VaRs [list Grids Width Beg End]
   if { $Comp == "x" } { set vC pX } else { set vC pY }

# STATE of 1 means we need to mute and enable settings (call generated by a
#   right click).  STATE of 0 means recompute all values (call generated by
#   a return).
 
# STATE 1:  Only process if selected widget state is normal (normal to 
#           muted and  muted to normal).
#           The number of grids widgets can not be muted

   if { $State == 1 } {
      if { [string match normal [$Wc cget -state] ] } {
         set Beg [lsearch $EnDs $iD]
         if { $Beg == 0 } { return }
         for { set I 1 } { $I < 4 } { incr I } {
            set Wb $bW.p${Comp}[lindex $EnDs $I]
            if { [string match disabled [$Wb cget -state] ] } {
               GUIstateSet $Wb REPLY normal
            }
         }
         if {$Beg == 1} { 
            set Wb $bW.p${Comp}wide
            GUIstateSet $Wb REPLY muted
         } else {
            set Wb $bW.p${Comp}beg
            GUIstateSet $Wb REPLY muted
            set Wb $bW.p${Comp}end
            GUIstateSet $Wb REPLY muted
         }
      }
   } else {
       set Wb $bW.p${Comp}[lindex $EnDs 1]
       set gN $euvANS(${vC}Grids) ; if {[string length $gN] == 0} { return }

       if { [string match disabled [$Wb cget -state] ] } {
          set gB $euvANS(${vC}Beg) ; if {[string length $gB] == 0} { return }
          set gE $euvANS(${vC}End) ; if {[string length $gE] == 0} { return }
          set V [expr ($gE - $gB) / double($gN)]
          set euvANS(${vC}Width) [format "%7.2f" $V]
       } else {
          set gW $euvANS(${vC}Width) ; if {[string length $gW] == 0} { return }
          set V [expr -($gN * $gW) / 2.0]
          set euvANS(${vC}Beg) [format "%7.2f" $V]
          set V [expr ($gN * $gW) / 2.0]
          set euvANS(${vC}End) [format "%7.2f" $V]
       }
       update
   }
}
