package provide EUVSim 1.0

proc GridOptMenu { } {
   global euvANS env Prefs

# LETS make the labels in the menu bold and titles a little larger

   set LFonT [list fixed $Prefs(FontSize) bold]
   set TFonT [list fixed [expr $Prefs(FontSize) + 4] bold ]
   set tC #0F0FAF
   set lC #FFFFFF

   set W  .giCOR

   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "EUV INVERSION GRID OPTIONS PAGE"
      wm withdraw $W

      set Wa .giCOR.top
      set Wb .giCOR.opts

      GUIFrame $Wa -1 pack|top||both
      GUIFrame $Wb -1 pack|top||both

      GUILabel $Wa.lab "GRID OPTION MENU" w pack|left 0 0 "" [list fixed 16]
      GUIbuttonPush $Wa.close CLOSE pack|right "wm withdraw $W" 6

      set Row 0
      GUILabel $Wb.lin "INSTRUMENT NOISE" w grid|$Row|0|ew||5 0 0 $tC $TFonT
      incr Row
      GUIblankRow $Wb $Row 0.5

      incr Row
      GUILabel $Wb.lgrd "Grid"     c grid|$Row|0|w  0 0 "" $LFonT
      GUILabel $Wb.lsta "Status"   c grid|$Row|1|w  0 0 "" $LFonT
      GUILabel $Wb.lloc "Location" c grid|$Row|2|ew 0 0 "" $LFonT
      GUILabel $Wb.lpix "Degrees"  c grid|$Row|3|ew 0 0 "" $LFonT
      GUILabel $Wb.lsig "Sigma"    c grid|$Row|4|ew 0 0 "" $LFonT
      incr Row

      set OOOps [list OFF|0 ON|1]

      set Ops [list TOP|0 BOTTOM|1 BOTH|2]
      GUILabel $Wb.ling "IMAGE (RAW)" w grid|$Row|0|w 0 0 $lC $LFonT
      set LaB [lindex [split [lindex $OOOps $euvANS(bkStat)] "|"] 0]
      GUIbuttonToggle $Wb.bkstat $LaB grid|$Row|1|ew $OOOps  \
           "GUIoptsToggle .giCOR.opts.bkstat euvANS(bkStat) ALT " 6
      set LaB [lindex [split [lindex $Ops $euvANS(bkLoc)] "|"] 0]
      GUIbuttonMenu $Wb.bkloc $LaB grid|$Row|2|ew $Ops  \
           "GUIoptsProcess .giCOR.opts.bkloc euvANS(bkLoc) ALT " 6
      GUIboxEntry $Wb.bkpix grid|$Row|3 7 euvANS(bkDeg)
      GUIboxEntry $Wb.bksig grid|$Row|4 7 euvANS(bkSig)

      incr Row
      GUIblankRow $Wb $Row 1.0
      incr Row
      GUILabel $Wb.lpc "PRECONDITIONING" w grid|$Row|0|ew||5 0 0 $tC $TFonT
      incr Row
      GUIblankRow $Wb $Row 0.5
      incr Row

      set Ops [list NO|0 3x3L|1 5x5L|2 3x3H|3 5x5H|4]
      GUILabel $Wb.lpcg "Grid" c grid|$Row|0|w 0 0 "" $LFonT
      GUILabel $Wb.lflt "Filter" c grid|$Row|1|ew 0 0 "" $LFonT
      GUILabel $Wb.ldcm "Decim"  c grid|$Row|2|ew 0 0 "" $LFonT
      incr Row
      GUILabel $Wb.pcg "IMAGE (RAW)" w grid|$Row|0|w 0 0 $lC $LFonT
      GUIbuttonMenu $Wb.mism $euvANS(miSm) grid|$Row|1 $Ops  \
           "GUIoptsProcess $Wb.mism euvANS(miSm) PRI " 6
      GUIboxEntry $Wb.midec grid|$Row|2 7 euvANS(miDec)

      incr Row
      GUIblankRow $Wb $Row 1.0
      incr Row
      GUILabel $Wb.lbk "BACKGROUND REMOVAL" w grid|$Row|0|ew||5 0 0 $tC $TFonT
      incr Row
      GUIblankRow $Wb $Row 0.5
      incr Row

      GUILabel $Wb.lbkg "Grid"      c grid|$Row|0|w 0 0 "" $LFonT
      GUILabel $Wb.lbks "Status"    c grid|$Row|1|ew 0 0 "" $LFonT
      GUILabel $Wb.lbkt "Type"      c grid|$Row|2|ew 0 0 "" $LFonT
      GUILabel $Wb.lbkl "Level"     c grid|$Row|3|ew 0 0 "" $LFonT

      incr Row
      set Ops [list OFF|0 ON|1]
      GUILabel $Wb.ubkg "IMAGE (RAW)" w grid|$Row|0|w 0 0 $lC $LFonT
      set LaB [lindex [split [lindex $Ops $euvANS(uBkStat)] "|"] 0]
      GUIbuttonToggle $Wb.ubk $LaB grid|$Row|1|ew $Ops  \
           "GUIoptsToggle .giCOR.opts.ubk euvANS(uBkStat) ALT " 6
      GUILabel $Wb.ubkl "UNIFORM" center grid|$Row|2|ew 0 0 "" $LFonT
      GUIboxEntry $Wb.ubklev grid|$Row|3 7 euvANS(uBkLev)

      incr Row
      GUILabel $Wb.cbkg "IMAGE (RAW)" w grid|$Row|0|w 0 0 $lC $LFonT
      set LaB [lindex [split [lindex $Ops $euvANS(cBkStat)] "|"] 0]
      GUIbuttonToggle $Wb.cbk $LaB grid|$Row|1|ew $Ops  \
           "GUIoptsToggle .giCOR.opts.cbk euvANS(cBkStat) ALT " 6
      GUILabel $Wb.cbkl "CUT" center grid|$Row|2|ew 0 0 "" $LFonT
      GUIboxEntry $Wb.cbklev grid|$Row|3 7 euvANS(cBkLev)


      incr Row
      GUIblankRow $Wb $Row 1.0
      incr Row
      GUILabel $Wb.lds "DESPECKLING" w grid|$Row|0|ew||5 0 0 $tC $TFonT
      incr Row
      GUIblankRow $Wb $Row 0.5
      incr Row

      GUILabel $Wb.ldsg "Grid"      c grid|$Row|0|w 0 0 "" $LFonT
      GUILabel $Wb.ldss "Status"    c grid|$Row|1|ew 0 0 "" $LFonT
      GUILabel $Wb.lneb "Neighbors" c grid|$Row|2|ew 0 0 "" $LFonT
      GUILabel $Wb.lmin "Minimum"   c grid|$Row|3|ew 0 0 "" $LFonT
      GUILabel $Wb.lrep "Repeat"    c grid|$Row|4|ew 0 0 "" $LFonT

      incr Row
      set Ops [list OFF|0 ON|1]
      GUILabel $Wb.dsi "IMAGE (RAW)" w grid|$Row|0|w 0 0 $lC $LFonT
      set LaB [lindex [split [lindex $Ops $euvANS(deSpeck)] "|"] 0]
      GUIbuttonToggle $Wb.desp $LaB grid|$Row|1|ew $Ops  \
           "GUIoptsToggle .giCOR.opts.desp euvANS(deSpeck) ALT " 6
      GUIboxEntry $Wb.neigh grid|$Row|2 7 euvANS(speckN)
      GUIboxEntry $Wb.spMin grid|$Row|3 7 euvANS(spMin)
      GUIboxEntry $Wb.spRep grid|$Row|4 7 euvANS(spRep)

      incr Row
      GUILabel $Wb.dspc "IMAGE (PC)" w grid|$Row|0|w 0 0 $lC $LFonT
      set LaB [lindex [split [lindex $Ops $euvANS(pcdeSpeck)] "|"] 0]
      GUIbuttonToggle $Wb.pcdesp $LaB grid|$Row|1|ew $Ops  \
           "GUIoptsToggle .giCOR.opts.pcdesp euvANS(pcdeSpeck) ALT " 6
      GUIboxEntry $Wb.pcneigh grid|$Row|2 7 euvANS(pcspeckN)
      GUIboxEntry $Wb.pcspMin grid|$Row|3 7 euvANS(pcspMin)
      GUIboxEntry $Wb.pcspRep grid|$Row|4 7 euvANS(pcspRep)

      incr Row
      GUILabel $Wb.dsds "SOLUTION (DEN)" w grid|$Row|0|w 0 0 $lC $LFonT
      set LaB [lindex [split [lindex $Ops $euvANS(sdeSpeck)] "|"] 0]
      GUIbuttonToggle $Wb.sdesp $LaB grid|$Row|1|ew $Ops  \
           "GUIoptsToggle .giCOR.opts.sdesp euvANS(sdeSpeck) ALT " 6
      GUIboxEntry $Wb.sneigh grid|$Row|2 7 euvANS(sspeckN)
      GUIboxEntry $Wb.sspMin grid|$Row|3 7 euvANS(sspMin)
      GUIboxEntry $Wb.sspRep grid|$Row|4 7 euvANS(sspRep)

      incr Row
      GUILabel $Wb.dszs "SOLUTION (ZERO)" w grid|$Row|0|w 0 0 $lC $LFonT
      set LaB [lindex [split [lindex $Ops $euvANS(zdeSpeck)] "|"] 0]
      GUIbuttonToggle $Wb.zdesp $LaB grid|$Row|1|ew $Ops  \
           "GUIoptsToggle .giCOR.opts.zdesp euvANS(zdeSpeck) ALT " 6
      GUIboxEntry $Wb.zneigh grid|$Row|2 7 euvANS(zspeckN)
      GUIboxEntry $Wb.zspMin grid|$Row|3 7 euvANS(zspMin)
      GUIboxEntry $Wb.zspRep grid|$Row|4 7 euvANS(zspRep)

      incr Row
      GUIblankRow $Wb $Row 1.0
      incr Row
      GUILabel $Wb.lrn "RADIAL NOISE" w grid|$Row|0|ew||5 0 0 $tC $TFonT
      incr Row
      GUIblankRow $Wb $Row 0.5
      incr Row

      set Ops [list OFF|0 ON|1]
      GUILabel $Wb.lrng "Grid"   c grid|$Row|0|w 0 0 "" $LFonT
      GUILabel $Wb.lrns "Status" c grid|$Row|1|ew 0 0 "" $LFonT
      GUILabel $Wb.lzrn "Zeros"  c grid|$Row|2|ew 0 0 "" $LFonT
      incr Row
      GUILabel $Wb.rnoiseg "SOLUTION (ZERO)" w grid|$Row|0|w 0 0 $lC $LFonT
      set LaB [lindex [split [lindex $Ops $euvANS(srNoise)] "|"] 0]
      GUIbuttonToggle $Wb.rnoise $LaB grid|$Row|1|ew $Ops  \
           "GUIoptsToggle .giCOR.opts.rnoise euvANS(srNoise) ALT " 6
      GUIboxEntry $Wb.zrg grid|$Row|2 7 euvANS(srGrids)

      incr Row
      GUIblankRow $Wb $Row 1.0
      incr Row
      GUILabel $Wb.lhs "HOTSPOT SUPRESSION" w grid|$Row|0|ew||5 0 0 $tC $TFonT
      incr Row
      GUIblankRow $Wb $Row 0.5
      incr Row

      GUILabel $Wb.lhsg "Grid"   c grid|$Row|0|w 0 0 "" $LFonT
      GUILabel $Wb.lhss "Status" c grid|$Row|1|ew 0 0 "" $LFonT
      GUILabel $Wb.lhsb "Base" c grid|$Row|2|ew 0 0 "" $LFonT
      GUILabel $Wb.lovr "Larger By" c grid|$Row|3|ew 0 0 "" $LFonT
      incr Row

      set Ops [list OFF|0 ON|1]
      GUILabel $Wb.hsg "SOLUTION (DEN)" w grid|$Row|0|w 0 0 $lC $LFonT
      set LaB [lindex [split [lindex $Ops $euvANS(hotSpot)] "|"] 0]
      GUIbuttonToggle $Wb.hsp $LaB grid|$Row|1|ew $Ops  \
           "GUIoptsToggle .giCOR.opts.hsp euvANS(hotSpot) ALT " 6
      GUIboxEntry $Wb.hsb grid|$Row|2 7 euvANS(hsBase)
      GUIboxEntry $Wb.hso grid|$Row|3 7 euvANS(hsOver)

      incr Row
      GUIblankRow $Wb $Row 1.0
      incr Row
      GUILabel $Wb.lzm "LINE OF SIGHT LIMITS" w grid|$Row|0|w||5 0 0 $tC $TFonT
      incr Row
      GUIblankRow $Wb $Row 0.5
      incr Row

      GUILabel $Wb.lmaxz "Max |Z|" c grid|$Row|1|ew 0 0 "" $LFonT
      GUILabel $Wb.lssz "Step Sz" c grid|$Row|2|ew 0 0 "" $LFonT
      incr Row
      GUILabel $Wb.losg "SOLUTION (ZERO)" w grid|$Row|0|w 0 0 $lC $LFonT
      GUIboxEntry $Wb.maxz grid|$Row|1 7 euvANS(ZMax)
      GUIboxEntry $Wb.zssz grid|$Row|2 7 euvANS(ZStepSz)
   }
}
