package provide EUVSim_C 1.0

# Func2D computes and returns values along a line of sight using the 2D
#   solution matrix for input.  The routine 

#  CurInfo allows current information of the LOS to be passed into the
#     routine.  Is modeled after ZeroSol.tcl in that it begins at the
#     minimum L-Shell value along the line of sight and moves outwards
#     in both directions until

#
#  CurInfo(0) - gN:    Grid number
#  CurInfo(1) - MinL:  Minimum L-Shell for which a Density exists
#  CurInfo(2) - BegX:  Beginning He Density Grid value along X
#  CurInfo(3) - BegY:  Beginning He Density Grid value along Y
#  CurInfo(4) - IncX:  He Density Grid increment along X
#  CurInfo(5) - IncY:  He Density Grid increment along Y
#  CurInfo(6) - LenX:  Number of He Density Grids along X
#  CurInfo(7) - LenY:  Number of He Density Grids along Y


proc Func2D { R dH nP cS OuT } {
   global CurInfo HdM SaTm HaTm euvANS dCoef

   upvar $OuT oV

   set gF [string match XY $euvANS(SolGrid)]

   set BeG [expr int(3 * $CurInfo(0))]
   for { set I 0 ; set J $BeG } { $I < 3 } { incr I ; incr J } {
      set hTm($I) $HaTm($J)
   }

   for { set I 0 } { $I < $nP } { incr I ; set R [expr $R + $dH]  } {
      for { set J 0 } { $J < 3 } { incr J } {
         set Xm($J) [expr $SaTm($J) + $hTm($J) * $R]
      }

      set D [TUvecMath Xm MAG Xm Xm]
      set XY [expr $Xm(0) * $Xm(0) + $Xm(1) * $Xm(1) + 1.0e-9]
      set Y [expr $D * $D * $D / $XY]
      set X [expr atan2($Xm(1), $Xm(0)) ]
      set gLaT [expr atan2($Xm(2), $XY) ]
      if $gF {
         set tX $X
         set tY $Y
         set X [expr $Y * cos($X)]
         set Y [expr $Y * sin($X)]
      }

      set RoW  [expr int(($Y - $CurInfo(3)) / $CurInfo(5))]
      if { ($RoW >= 0) && ($RoW < $CurInfo(7)) } { 
         set CoL [expr int(($X - $CurInfo(2)) / $CurInfo(4))]
         if { $CoL <  0 } { set CoL [expr $CurInfo(6) + $CoL] }
         set CoL [expr $CoL % $CurInfo(6)]
         set gN [expr int($RoW * $CurInfo(6) + $CoL)] 
         set oV($I) [expr $HdM($gN) * [TUpolyExp1D $gLaT $euvANS(ndC) $dCoef]]
      } else { set oV($I) 0.0 }
   }

   return 0
}
