package provide EUVSim_C 1.0

#  CurInfo allows current information of the LOS to be passed into the
#  routine.
#
#  CurInfo(0) - gN:    Grid number
#  CurInfo(1) - MaxL:  Maximum L-Shell for which a Density exists

proc Func1D { R dH nP cS OuT } {
   global CurInfo HaTm SaTm euvANS

   upvar $OuT oV

   set B(0) 0.0
   set B(1) -.715

   set BeG [expr int(3 * $CurInfo(0))]
   for { set I 0 ; set J $BeG } { $I < 3 } { incr I ; incr J } {
      set hTm($I) $HaTm($J)
   }

   for { set I 0 } { $I < $nP } { incr I ; set R [expr $R + $dH]  } {
      for { set J 0 } { $J < 3 } { incr J } {
         set Xm($J) [expr $SaTm($J) + $hTm($J) * $R]
      }

      set D [TUvecMath Xm MAG Xm Xm]
      set XY [expr $Xm(0) * $Xm(0) + $Xm(1) * $Xm(1) + 1.0e-9]
      set lS [expr $D * $D * $D / $XY]
      if {$lS <= $CurInfo(1) } {
         set oV($I) [expr pow(10.0, [TUpolyExp1D $lS 2 B 0 100, -100])]
      } else { set oV($I) 0.0 }
   }
}
