package provide EUVSim 1.0

proc DynamicPlots { } {
   global euvANS pPg tiImG miImG gBIM gIMG gHDM

# SET up the plot limits for the plasmasphere plots and SM MiImG plot

   set euvANS(psBeg) $euvANS(psMn)  
   set euvANS(psEnd) [expr $euvANS(psMn) - 2.0 * $euvANS(psMn)]  
   set euvANS(eqBeg) $euvANS(eqMn)  
   set euvANS(eqEnd) [expr $euvANS(eqMn) - 2.0 * $euvANS(eqMn)]  
   set euvANS(agBeg) $euvANS(agMn)  
   set euvANS(agEnd) [expr $euvANS(agMn) - 2.0 * $euvANS(agMn)]  
   set euvANS(rgBeg) $euvANS(rgMn)  
   set euvANS(rgEnd) [expr $euvANS(rgMn) - 2.0 * $euvANS(rgMn)]  

   set dPLen [llength $euvANS(PiD)]

   set dX [expr abs($euvANS(mXEnd) - $euvANS(mXBeg))]

#  MAKE a first pass through the dynamic plots and get the largest and
#    smallest aspect ratios for those plots which need to be put up
#    with their X and Y axes plotted on the same physical scale.

   for { set I 0 } { $I < $dPLen } { incr I } {
      set pID [lindex $euvANS(PiD) $I]
      if { $euvANS(${pID}Do) > 0 } {
         set pN $euvANS(${pID}Pg)
         switch -exact -- $pID {
            mi  -
            si  -
            li  -
            ri  {  
               if ![info exists MxA($pN)] { set MxA($pN) 0.0 }
               set dX [expr abs($euvANS(mXEnd) - $euvANS(mXBeg))]
               set dY [expr abs($euvANS(mYEnd) - $euvANS(mYBeg))]
               set Aspect [expr $dY / $dX] 
               if { $Aspect > $MxA($pN) } { set MxA($pN) $Aspect }
            }
            eq  -
            ps  -
            rg  -
            rc  -
            ag  {
               if ![info exists MxA($pN)] { set MxA($pN) 0.0 }
               set Aspect 1.0
               if { $Aspect > $MxA($pN) } { set MxA($pN) $Aspect }
            }
            zm  -
            rm  -
            sm  {
               if [string match XY $euvANS(SolGrid)] {
                  if ![info exists MxA($pN)] { set MxA($pN) 0.0 }
                  set Aspect 1.0
                  if { $Aspect > $MxA($pN) } { set MxA($pN) $Aspect }
               }
            }
         }
      }
   }

#  SET up plot windows. 

   set sN 0
   set dPLen [llength $euvANS(PiD)]
   for { set I 0 } { $I < $dPLen } { incr I } {
      set pID [lindex $euvANS(PiD) $I]
      set pN $euvANS(${pID}Pg)

      if { $euvANS(${pID}Do) == 0 } { continue }
      if ![info exists MxA($pN)] { 
         set Aspect $euvANS(DefAspect)
      } else { set Aspect $MxA($pN) }

      set MaxX $euvANS(MaxPix)
      set MaxY $euvANS(MaxPix)
      set TotA [expr $MaxX * $MaxY]
      set TotP $pPg($pN)
      set Ratio $TotA
      set pCols 1
      while { $pCols <= $TotP } {
         set LastRatio $Ratio
         set pX [expr int($MaxX / $pCols)]
         set pRows [expr int($TotP / $pCols)]
         if { [expr $pCols * $pRows] != $TotP } { incr pRows }
         set pY [expr int($pX * $Aspect)]

         set TotY [expr $pY * $pRows]
         if { $TotY > $MaxY } {
            set pY [expr int($MaxY / $pRows)]
            set pX [expr int($pY / $Aspect)]
         }
         set Area [expr $pX * $pY * $TotP ]
         set Ratio [expr $TotA / double($Area)]
         if { $Ratio < $LastRatio } {
            incr pCols
            set LastRatio $Ratio
         } else {  break }
      }

      incr pCols -1
      set LenX [expr int($MaxX / $pCols)]
      set pRows [expr int($TotP / $pCols)]
      if { [expr $pCols * $pRows] != $TotP } { incr pRows }
      set pY [expr int($pX * $Aspect)]
      if { $TotY > $MaxY } {
          set pY [expr int($MaxY / $pRows)]
          set pX [expr int($pY / $Aspect)]
      }

      set pW .pWin$pN
      if ![winfo exists $pW] {
        toplevel $pW

        set euvANS(pW$pN) ""
        set euvANS(sN$pN) ""
        wm title . "PLOT WINDOW $pN"

        for { set K 1 } { $K <= $pRows} { incr K } {
           set wPa $pW.pp$K
           GUIFrame $wPa -1 pack|top||both
           for { set L 1 } { $L <= $pCols } { incr L ; } {
              set wPl ${wPa}.p$L
              GUIFrame $wPl -1 pack|left||both
              GUICanvas $wPl $pX $pY $pX $pY
              lappend euvANS(pW$pN) $wPl
              lappend euvANS(sN$pN) $sN 
              SetScreen $sN $wPl
              incr sN
           }
        }
      } else {
         for { set K 1 } { $K <= $pRows} { incr K } {
            set wPa $pW.pp$K
            for { set L 1 } { $L <= $pCols } { incr L ; } {
               set wPl ${wPa}.p$L.drw
               if ![winfo exists $wPl] {
                  GUIobjConfig $wPl CANVAS [list WIDTH HEIGHT] [list  $pX $pY]
               }
            }
         }
      }

      if { [string compare mi $pID] == 0 } {
         bind $wPl.drw <Button-1> {GetLoc %W %x %y }
      }
   }  

   set gIMG(0) $euvANS(mXBeg)
   set gIMG(1) $euvANS(mXEnd)
   set gIMG(2) $euvANS(mYBeg)
   set gIMG(3) $euvANS(mYEnd)
   TUgridReGrid CUT tiImG gBIM miImG gIMG END 

   if [NoData] { return 0 }

   if $euvANS(bkStat) { RmBkgnd 1 }

   if { $euvANS(uBkStat) == 1 } {
       TUgridNoise UNIFORM miImG gIMG $euvANS(uBkLev) 0.0 0.0
   }

   if { $euvANS(cBkStat) == 1 } {
       TUgridNoise CUT miImG gIMG $euvANS(cBkLev) 0.0 0.0
   }

   if { $euvANS(deSpeck) == 1 } {
      for { set I 0 } { $I < $euvANS(spRep) } { incr I } {
         TUgridNoise DESPECKLE miImG gIMG $euvANS(speckN) $euvANS(spMin) 0.0
      }
   }

# IF there are any masks defined the apply them now 

   MaskOut 

# IF we need to compute the lines of sight then do it now before we
#    decimate the image if that is going to be done

   MassageGrid miImG moG moN moGI mi
   unset miImG
   unset gIMG
   TUgridMath moG DUP moG miImG moGI
   set nE [array size moGI]
   for { set I 0 } { $I < $nE} { incr I } { set gIMG($I) $moGI($I) }
   
   CropImG

   update
   return 1
}
