#include <tcl.h>

int Func1DCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int Func2DCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int LoSCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int LosEndCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int ZeroSolCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 

int Tcleuvsim_Init (Tcl_Interp *interp) {
   Tcl_CreateObjCommand (interp, "Func1D", Func1DCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "Func2D", Func2DCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "LoS", LoSCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "SetLosEnds", LosEndCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "ZeroSol", ZeroSolCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_PkgProvide(interp, "EUVSim_C",  "2.0");

   return TCL_OK;
}
