/*  The C equivalent of Iterate,  It consists of a TCL interface over       */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are  2 OBJV elements.  These are:                                 */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  R                                     (nG)                 */
/*     OBJV[2]:  Beginning integration step            (BegI)               */
/*     OBJV[3]:  Integration Step Size                 (dH)                 */
/*     OBJV[4]:  Number of Steps                       (nS)                 */
/*     OBJV[5]:  Current Step                          (cS)                 */

#include <tcl.h>
#include <stdlib.h>
#include <math.h>
#include "ByteDefs.h"
#include "TeuvsimAnsi.h"
#include "TutilAnsi.h"

int Func1DCmd (ClientData Cd, Tcl_Interp *tI, 
                                int objc, Tcl_Obj *CONST *objv) 
{
   static void *memPtr;
   ReaL_8 *V;
   ReaL_8 TmP, MaxL, lD, lS;
   ReaL_8  hTm[3], sTm[3], Xm[3], R, BegI, dH, D, XY;
   ByTe_4  I, J, LastS, Bytes;
   int     nS, cS, gN;
   Tcl_Obj *objPtr;
   int Flg = TCL_LEAVE_ERR_MSG;
   char *Value, Index[10];

/* Make sure that all the IO parameters are present */

   if (objc < 5 ) {
      Tcl_WrongNumArgs(tI, 1, objv, "Usage: Func1D ... ");
      return TCL_ERROR;
   }

/* Get the non-array inputs                                                 */

   Tcl_GetDoubleFromObj (tI, objv[1], &BegI);
   Tcl_GetDoubleFromObj (tI, objv[2], &dH);
   Tcl_GetIntFromObj (tI, objv[3], &nS);
   Tcl_GetIntFromObj (tI, objv[4], &cS);
   LastS = nS -1;

/* This is the current set of polynomial coefficients for density           */

/* Get the global inputs                                                    */

   Tcl_UpVar (tI, "#0", "CurInfo", "cI", 0);
   Tcl_UpVar (tI, "#0", "SaTm", "sT", 0);
   Tcl_UpVar (tI, "#0", "HaTm", "hT", 0);

   if ((Value = Tcl_GetVar2(tI, "cI", "0", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &TmP);
      gN = TmP;
   } 

   if ((Value = Tcl_GetVar2(tI, "cI", "1", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &MaxL);
   } 

/* Load up the line of sight info for the pixel and the satellite position. */

   J = 3 * gN; 
   for (I = 0; I < 3; ++I, ++J) {
      sprintf (Index, "%d", I);
      if ((Value = Tcl_GetVar2(tI, "sT", Index, Flg)) != NULL) {
         Tcl_GetDouble (tI, Value, &sTm[I]);
      }
      sprintf (Index, "%d", J);
      if ((Value = Tcl_GetVar2(tI, "hT", Index, Flg)) != NULL) {
         Tcl_GetDouble (tI, Value, &hTm[I]);
      }
   }

/* Get the global inputs                                                    */

   if ( cS <= 0 ) {
      Bytes = nS * sizeof(ReaL_8);
      if ((memPtr = malloc (Bytes)) == NULL)
         return TCL_ERROR;
      V = (ReaL_8 *)memPtr; 
   
      R = BegI;
      for (I = 0; I < nS; ++I, R += dH) {
         for (J = 0; J < 3; ++J ) { Xm[J] = sTm[J] + hTm[J] * R; }
         XY = Xm[0] * Xm[0] + Xm[1] * Xm[1];
         D = XY + Xm[2] * Xm[2];
         lS = D * sqrt(D) / (XY + 1.0e-9);
         if (lS <= MaxL) {
            lD = -.715 * lS;
            V[I] = pow(10.0, lD);
         } else { V[I] = 0.0; }
      }
   }

   if ( cS < 0 ) {
      CArrayToTcl (tI, objv[5], V, nS, 0, 'D');
      free (memPtr);
   } else {
      V = (ReaL_8 *)memPtr;
      objPtr = Tcl_GetObjResult(tI);
      Tcl_SetDoubleObj (objPtr, (double)V[cS]);
      if (cS == LastS) { free (memPtr); }
   }

   return TCL_OK;
}
