# first we load in the standard vtk packages into tcl

package require vtk
package require vtkinteraction
package require vtktesting

# MAKE sure that all of the sources are identified to the program
 
source [ file join $env(TCLTOOLS_HOME) TclToolInits.tcl ]
TclToolInits GPH GUI PLT UTILS

lappend auto_path [file join $env(TCLTOOLS_HOME) TclEUVSim]
package require EUVSim
package require EUVSim_C

vtkMath math

GraphicsOn VTK ETones

set aF [ReadEUVInv 2001146001158.sim  X Y D gI AnC]
set nP [expr $gI(4) * $gI(5)]

set gI(10) NEW:ADD:END
set gI(4) 100
set gI(5) 100
set gI(0) [expr -$gI(3)]
set gI(1) $gI(3)
set gI(2) [expr -$gI(3)]
set g(15) NO
set g(15) NO

for { set I 0 } { $I < $nP } { incr I } {
  set Gx($I) [expr $Y($I) * cos($X($I))]
  set Gy($I) [expr $Y($I) * sin($X($I))]
}
 
set sI(0) 1 ; set sI(1) 5 ; set sI(2) 4
set sI(3) 2 ; set sI(4) 1 ; set sI(5) 0
set sI(6) 0 ; set sI(7) 0 ; set sI(8) -2

set sOp 1

TUdataGrid $nP 1 Gx Gx 1 Gy Gy D GriD gNorM gI
TUgridFill2D GriD gI "" sI
#TUgridSmooth 2DFILTER GriD gI sOp

set I  0
vtkFloatArray xV
   for { set C 0 } { $C < $gI(4) } { incr C } {
      TUgridInfo 1 gI rV $C 0
      TUgridInfo 20 gI rI $rV(0)
      xV InsertNextValue [expr $rI(2) * 50]
   }

vtkFloatArray yV
   for { set R 0 } { $R < $gI(5) } { incr R } {
      TUgridInfo 1 gI rV 0 $R
      TUgridInfo 20 gI rI $rV(0)
      yV InsertNextValue [expr $rI(3) * 50]
   }

vtkFloatArray zV
  zV InsertNextValue 0.0
										set tG [expr $gI(4) * $gI(5)]
vtkFloatArray dV
   for { set C 0 } { $C < $gI(4) } { incr C } {
      for { set R 0 } { $R < $gI(5) } { incr R } {
         TUgridInfo 1 gI rV $C $R
         if { $GriD($rV(0)) > 0.0 } {
            dV InsertNextValue [expr log10($GriD($rV(0)))]
         } else { dV InsertNextValue -1.0 }
      }
   }


# CREATE a 100 by 100 rectilinear dataset
 
 vtkRectilinearGrid rGriD
   rGriD SetDimensions $gI(4) $gI(5) 1
   rGriD SetXCoordinates xV
   rGriD SetYCoordinates yV
   rGriD SetZCoordinates zV
   [rGriD GetPointData] SetScalars dV
                                                       
 vtkRectilinearGridGeometryFilter iPlane
   iPlane SetInput rGriD
   iPlane SetExtent 0  99  0  99  0 0

 vtkWarpScalar iWarp
    iWarp SetInput [iPlane GetOutput]
    iWarp SetScaleFactor 10.
    iWarp SetXFactor 10.

 vtkPolyDataMapper iMapper
    iMapper SetLookupTable colorLUT
    iMapper SetScalarRange 0.0 3.3
    iMapper SetInput [iPlane GetOutput]
#   iMapper SetInputConnection [iPlane GetOutputPort]

vtkActor iActor
  iActor SetMapper iMapper

vtkRenderer ren1
vtkRenderWindow renWin
    renWin AddRenderer ren1
vtkRenderWindowInteractor iren
    iren SetRenderWindow renWin

ren1 AddActor iActor
renWin SetSize 500 500

ren1 SetBackground 0 0 0
                                                                                
# render the image
#
iren AddObserver UserEvent {wm deiconify .vtkInteract}
renWin Render

# prevent the tk window from showing up then start the event loop
wm withdraw .

