# first we load in the standard vtk packages into tcl

package require vtk
package require vtkinteraction
package require vtktesting

# MAKE sure that all of the sources are identified to the program
 
source [ file join $env(TCLTOOLS_HOME) TclToolInits.tcl ]
TclToolInits GPH GUI PLT UTILS

lappend auto_path [file join $env(TCLTOOLS_HOME) TclEUVSim]
package require EUVSim
package require EUVSim_C

vtkMath math

GraphicsOn VTK ETones
#colorLUT SetTableRange 0.0 3.3

#vtkLookupTable lutBlue
#  lutBlue SetNumberOfColors 20
#  lutBlue SetHueRange 0.88 0.88
#  lutBlue SetSaturationRange 0.4 0.1
#  lutBlue SetValueRange 0.55 0.9
#  lutBlue Build

#vtkLookupTable lutRed
#  lutRed SetNumberOfColors 20
#  lutRed SetHueRange 0.0 0.0
#  lutRed SetSaturationRange 0.4 0.1
#  lutRed SetValueRange 0.55 0.9
#  lutRed Build

 set aF [ReadEUVInv /we/chris/PaperPlume/2001129095630.sim X Y GriD gI AnC]
#set aF [ReadEUVInv /we/chris/PaperRefill/2001129095630.sim  X Y D gI AnC]
#set nP [expr $gI(4) * $gI(5)]

#set gI(10) NEW:ADD:END
#set gI(4) 150
#set gI(5) 150
#set gI(0) [expr -$gI(3)]
#set gI(1) $gI(3)
#set gI(2) [expr -$gI(3)]
#set g(15) NO
#set g(15) NO

#for { set I 0 } { $I < $nP } { incr I } {
#  set Gx($I) [expr $Y($I) * cos($X($I))]
#  set Gy($I) [expr $Y($I) * sin($X($I))]
#}
 
#set sI(0) 1 ; set sI(1) 5 ; set sI(2) 4
#set sI(3) 2 ; set sI(4) 1 ; set sI(5) 0
#set sI(6) 0 ; set sI(7) 0 ; set sI(8) -2
#
#set sOp 1
#
#TUdataGrid $nP 1 Gx Gx 1 Gy Gy D GriD gNorM gI
#TUgridFill2D GriD gI "" sI

set fE [list 1.0  2.0  1.0 \
             2.0  4.0  2.0 \
	     1.0  2.0  1.0 ]

set nE [llength $fE]
if { $nE > 0 } {
   set SuM 0.0
   for { set K 0 } { $K < $nE } { incr K } {
      set F($K) [lindex $fE $K]
      set SuM [expr $SuM + abs($F($K))]
   }
   for { set K 0 } { $K < $nE } { incr K } {
      set F($K) [expr $F($K) / $SuM]
   }


   set sOp(0) 0
   TUgridFilter 2DFILTER GriD gI sOp F
}

#TUgridSmooth 2DFILTER GriD gI sOp

set I  0
vtkFloatArray xV
  xV SetNumberOfTuples $gI(4)
  xV SetNumberOfComponents 1
   for { set C 0 } { $C < $gI(4) } { incr C } {
      TUgridInfo 1 gI rV $C 0
      TUgridInfo 20 gI rI $rV(0)
      xV SetTuple1 $C $rI(2)
   }

vtkFloatArray yV
  yV SetNumberOfTuples $gI(5)
  yV SetNumberOfComponents 1
   for { set R 0 } { $R < $gI(5) } { incr R } {
      TUgridInfo 1 gI rV 0 $R
      TUgridInfo 20 gI rI $rV(0)
      yV SetTuple1 $R $rI(3)
   }

vtkFloatArray zV
  zV SetNumberOfTuples 1
  zV SetNumberOfComponents 1
  zV SetTuple1 0 0.0
                                                                                
vtkFloatArray dV
   set N 0
   dV SetNumberOfValues 1
   dV SetNumberOfTuples [expr 2 * $gI(4) * $gI(5)]
   for { set C 0 } { $C < $gI(4) } { incr C } {
      for { set R 0 } { $R < $gI(5) } { incr R } {
         TUgridInfo 1 gI rV $C $R
         if { $GriD($rV(0)) > 0.0 } {
            dV SetTuple1 $N [expr log10($GriD($rV(0)))]
         } else { dV SetTuple1 $N -1.0 }
         incr N
      }
   }

#set nP [ReadMENAInv MENA20011530202.inv X Y D ]
#set gI(10) NEW:ADD:END
#set gI(15) NO
#set gI(16) NO
#
#TUdataGrid $nP 1 X X 1 Y Y D GriD gNorM gI
#TUgridFill2D GriD gI "" sI
#
#dV SetNumberOfTuples [expr 2 * $gI(4) * $gI(5)]
#for { set C 0 } { $C < $gI(4) } { incr C } {
#   for { set R 0 } { $R < $gI(5) } { incr R } {
#      TUgridInfo 1 gI rV $C $R
#      dV SetTuple1 $N $GriD($rV(0))
#      incr N
#   }
#}

# CREATE a 100 by 100 point plane to sample 
 
 vtkImageData rGriD
   rGriD SetDimensions $gI(4) $gI(5) 1
   [rGriD GetPointData] SetScalars dV

 vtkImageDataGeometryFilter  pplane
   pplane SetInput rGriD
   pplane SetExtent 0  [expr $gI(4) - 1]  0  [expr $gI(5) - 1]  0  0
 
 vtkWarpScalar pWarp
    pWarp SetInput [pplane GetOutput]
    pWarp SetScaleFactor 10.0
                                                                                
#vtkPolyDataNormals pnormals
#  pnormals SetInput [pWarp GetOutput]
#  pnormals SetFeatureAngle 60
#  pnormals ConsistencyOff
#  pnormals SplittingOff
                                                                               
# Create the mapper and actor for the structrued grid

vtkPolyDataMapper pMapper
  pMapper SetLookupTable colorLUT
  pMapper SetScalarRange 0.0 3.3
  pMapper SetInput [pWarp GetOutput]

#vtkPolyDataMapper iMapper
#  iMapper SetLookupTable lutRed
#  iMapper SetScalarRange 0.0 1.6e5
#  iMapper SetInput [pWarp GetPolyDataOutput]

vtkActor pActor
  pActor SetMapper pMapper

#vtkActor iActor
#  iActor SetMapper iMapper
#  [iActor GetProperty] SetOpacity 0.3

#vtkPolyDataMapper edgeMapper
#  edgeMapper SetInput [ibcf GetContourEdgesOutput]
#  edgeMapper SetResolveCoincidentTopologyToPolygonOffset
                                                                                
#vtkActor cActor
#  cActor SetMapper edgeMapper
#  [cActor GetProperty] SetOpacity 0.5
 
#
# Create the RenderWindow, Renderer
#
vtkRenderer ren1
vtkRenderWindow renWin
    renWin AddRenderer ren1
vtkRenderWindowInteractor iren
    iren SetRenderWindow renWin

ren1 AddActor pActor
#ren1 AddActor iActor
#ren1 AddActor cActor
renWin SetSize 500 500

ren1 SetBackground 0 0 0
# [ren1 GetActiveCamera] Zoom 1.0
                                                                                
# render the image
#
iren AddObserver UserEvent {wm deiconify .vtkInteract}
renWin Render

# prevent the tk window from showing up then start the event loop
wm withdraw .

