catch {load vtktcl}
if { [catch {set VTK_TCL $env(VTK_TCL)}] != 0} { set VTK_TCL "/opt/vtk/examplesTcl" }

# Generate implicit model of a sphere
#
source $VTK_TCL/vtkInt.tcl
source $VTK_TCL/colors.tcl

# Create renderer stuff
#
vtkRenderer ren1
vtkRenderWindow renWin
    renWin AddRenderer ren1
vtkRenderWindowInteractor iren
    iren SetRenderWindow renWin

# create pipeline
#
vtkSphere sphere
    sphere SetRadius .4
vtkSampleFunction sample
    sample SetImplicitFunction sphere
vtkContourFilter iso
    iso SetInput [sample GetOutput]
    iso SetValue 0 0.0
vtkPolyDataMapper isoMapper
    isoMapper SetInput [iso GetOutput]
    isoMapper ScalarVisibilityOff
vtkActor isoActor
    isoActor SetMapper isoMapper
    eval [isoActor GetProperty] SetColor $peacock

vtkOutlineFilter outline
    outline SetInput [sample GetOutput]
vtkPolyDataMapper outlineMapper
    outlineMapper SetInput [outline GetOutput]
vtkActor outlineActor
    outlineActor SetMapper outlineMapper
    [outlineActor GetProperty] SetColor 0 0 0

vtkPlaneSource plane1
    plane1 SetResolution 50 50
    plane1 SetOrigin 0 0 0
    plane1 SetPoint1  0 0 -2
    plane1 SetPoint2 -2 0 0
    plane1 SetCenter 0 0 0
    plane1 SetNormal 0 1 0
    plane1 Update
vtkPolyDataMapper planeMapper1
    planeMapper1 SetInput [plane1 GetOutput]
vtkActor planeActor1
    planeActor1 SetMapper planeMapper1
    [planeActor1 GetProperty] SetRepresentationToWireframe

vtkPlaneSource plane2
    plane2 SetResolution 50 50
    plane2 SetOrigin 0 0 0
    plane2 SetPoint1  0 0 -2
    plane2 SetPoint2 -2 0 0
    plane2 SetCenter 0 -1 0
    plane2 SetNormal 0 1 0
    plane2 Update
vtkPolyDataMapper planeMapper2
    planeMapper2 SetInput [plane2 GetOutput]
vtkActor planeActor2
    planeActor2 SetMapper planeMapper2
    [planeActor2 GetProperty] SetRepresentationToWireframe


vtkLight Light
  Light SetColor 1 1 1
  Light SetFocalPoint 0 0 0
  Light SetPosition -116 76  55 

vtkCamera camera
   camera SetFocalPoint 0 0 0 
   camera SetPosition 0.0 10.0 0.5
   camera ComputeViewPlaneNormal
   camera SetViewUp  0. 0. 0.
   camera Dolly 1.4


# Add the actors to the renderer, set the background and size
#
ren1 SetActiveCamera camera
ren1 AddLight Light
ren1 AddActor outlineActor
ren1 AddActor isoActor
ren1 AddActor planeActor1
ren1 AddActor planeActor2
ren1 SetBackground 1 1 1
renWin SetSize 500 500
iren Initialize
iren LightFollowCameraOff

# render the image
#
iren SetUserMethod {wm deiconify .vtkInteract}

#renWin SetFileName "sphere.tcl.ppm"
#renWin SaveImageAsPPM

# prevent the tk window from showing up then start the event loop
wm withdraw .


