package provide EUVSim 1.0

proc VtkDmp { mH { Kp 0 } { WR 0 } } {
   global euvANS SuN SpiN SaT Yr Dy Msec mInfo

   upvar $mH Mesh

   if { $WR == 1 } {
      set  Time [UTILtime $Yr(0) $Dy(0) $Msec(0) 0 0]

      set Hr [expr $Msec(0) / 3600000 ]
      set Mn [expr ($Msec(0) % 3600000) / 60000 ]
      set Ss [expr ($Msec(0) % 60000) / 1000 ]
      set Ms [expr $Msec(0) % 1000]

      puts $euvANS(vtkFile) "set Yr $Yr(0)"
      puts $euvANS(vtkFile) "set Dy $Dy(0)"
      puts $euvANS(vtkFile) "set Hr $Hr"
      puts $euvANS(vtkFile) "set Mn $Mn"
      puts $euvANS(vtkFile) "set Ss $Ss"
      puts $euvANS(vtkFile) "set Ms $Ms"
      puts $euvANS(vtkFile) "set Msec $Msec(0)"
      puts $euvANS(vtkFile) "set Kp $Kp"
      puts $euvANS(vtkFile) "set Order $euvANS(fOrder)"
      for { set I 0 } { $I < 3 } { incr I } {
         puts $euvANS(vtkFile) "set SuN($I) $SuN($I)"
         puts $euvANS(vtkFile) "set SaT($I) $SaT($I)"
         puts $euvANS(vtkFile) "set SpiN($I) $SpiN($I)"
      }
      for { set I 0 } { $I < 15 } { incr I } {
         puts $euvANS(vtkFile) "set mInfo($I) $mInfo($I)"
      }

      set TotG [expr $mInfo(4) * $mInfo(5)]
      for { set I 0 } { $I < $TotG } { incr I } {
         puts $euvANS(vtkFile) "set Mesh($I) $Mesh($I)"
      }
   } else {
      if { [file exists $AnS(VTKFn)] == 1 } {
         set euvANS(vtkFile) [open $AnS(VTKFn) r]
      } else {
         puts stderr "No VTK DATA File $AnS(VTKFn)"
         exit
      }

      while { [gets $euvANS(vtkFile) line] >= 0 } { eval $line }
   }

   close $euvANS(vtkFile)
}
