package provide EUVSim 1.0

# THE procedure sets the measured image grid size.  This is done using
#    the user input mesh size and the desired extent of the plot in the
#    geomagnetic equator.  

proc SetGridSize {  } {
   global RtoD euvANS Re Yr Dy Msec SaT SpiN gHDM

# SET the Minimum LShell Limits

   if { $euvANS(lMax) < 0.0 } {
      set euvANS(lSLim) [expr -.46666 * $euvANS(kP) + 5.76 - $euvANS(lMax)]
   } else { set euvANS(lSLim) $euvANS(lMax) }

# ESTABLISH xInfo matrix used in coordinate system transformations

   TUtimeJulian $Yr(0) $Dy(0) $Msec(0) xInfo 1

# BUILD the rotation matrix which will rotate the satellite spin axis to
#    be parallel to the GCI Z axis.  Also get its transpose to rotate
#    back into the native orientation.
                                                                                
   set Phi   [expr atan2($SpiN(1), $SpiN(0)) * $RtoD + 90.0]
   set XY    [expr sqrt ($SpiN(0) * $SpiN(0) + $SpiN(1) * $SpiN(1))]
   set Theta [expr atan2 ($XY, $SpiN(2)) * $RtoD ]
   set Psi [expr -$Phi]
                                                                                
   TUmatrixRot $Phi $Theta $Psi R1 EULER
   TUmatrixMath R1 TRANSPOSE R1 r1T 3 3 3 3

#  ROTATE the satellite so that its spin axis is || to the GCI +z axis.
#    Subtract the Earth's position from the rotated vector.  This places
#    the satellite at the origin.
                                                                                
   TUmatrixMath R1 * SaT rE 3 3 3 1
                                                                          
#  GET the satellite position in SM coordinates in units of Re
                                                                                
   set TmP(0) $Re
   TUdataCT SaT GEI xInfo SaTm SM
   TUvecMath SaTm / TmP SaTm 0 0 0 3 1
                                                                                
#  COMPUTE the nadir angle (this is the spin angle at which the XZ plane
#    of the satellite contains the Earth.  The negative sign is used
#    to translate the Earth to the origin for the computation.
                                                                                
         set Nadir [expr atan2(-$rE(1), -$rE(0)) * $RtoD]

# NOW to the loop.  We don't need to do every pixel in the image just some
#     along the edges to determine how far the image needs to extend to
#     cover the SM equatorial limits in the inversion.

   set SgN -
   for { set I 0 } { $I < 2 } { incr I } {
      set lS 0.0
#     set Theta [expr 0.0 + $euvANS(thShift)]
#     set Phi [expr 0.0 - $euvANS(phShift)]
      set Theta 0.0
      set Phi   0.0

#     set sTh [expr sin($Theta / $RtoD)]
#     set cTh [expr cos($Theta / $RtoD)]
      set sTh 0.0
      set cTh 1.0

      while { ($Phi < 90.0) && ($lS < $euvANS(lSLim)) } {
         set Ang [expr ($Nadir $SgN $Phi) / $RtoD] 

         set pHat(0) [expr cos($Ang) * $cTh]
         set pHat(1) [expr sin($Ang) * $cTh]
         set pHat(2) [expr $sTh]

#  PRODUCE look directions in the SM reference frame  
                                                                                
         TUmatrixMath r1T * pHat Hat  3 3 3 1
         TUdataCT Hat GEI xInfo TmP1 SM

# FIND the intercept of the look direction with the SM equatorial plane.
                                                                                
         if { $TmP1(2) == 0.0 } { TmP1(2) = 1.0e-9 }
                                                                                
         set Dir [expr $SaTm(2) * $TmP1(2)]
         if { $Dir < 0 } {
            set xSm [expr $SaTm(0) - $TmP1(0) * $SaTm(2) / $TmP1(2)]
            set ySm [expr $SaTm(1) - $TmP1(1) * $SaTm(2) / $TmP1(2)]
            set lS [expr sqrt($xSm * $xSm + $ySm * $ySm)]
         } 
                                                                                
         set Phi [expr $Phi + 1.0]
      }
      set SgN +
      set Phase($I) [expr $Phi - 1.0]
   }

   for { set I 0 } { $I < 2 } { incr I } {
      set lS 0.0
#     set Theta [expr 0.0 + $euvANS(thShift)]
#     set Phi [expr 0.0 - $euvANS(phShift)]
      set Theta 0.0
      set Phi   0.0

      set Ang [expr $Nadir / $RtoD] 
      set cPhi [expr cos($Ang)]
      set sPhi [expr sin($Ang)]
      while { ($Theta < 44.0) && ($lS < $euvANS(lSLim)) } {
         set sTh [expr sin($Theta / $RtoD)]
         set cTh [expr cos($Theta / $RtoD)]

         set pHat(0) [expr $cPhi * $cTh]
         set pHat(1) [expr $sPhi * $cTh]
         set pHat(2) [expr $sTh]

#  PRODUCE look directions in the SM reference frame  
                                                                                
         TUmatrixMath r1T * pHat Hat  3 3 3 1
         TUdataCT Hat GEI xInfo TmP1 SM

# FIND the intercept of the look direction with the SM equatorial plane.
                                                                                
         if { $TmP1(2) == 0.0 } { TmP1(2) = 1.0e-9 }
                                                                                
         set Dir [expr $SaTm(2) * $TmP1(2)]
         if { $Dir < 0 } {
            set xSm [expr $SaTm(0) - $TmP1(0) * $SaTm(2) / $TmP1(2)]
            set ySm [expr $SaTm(1) - $TmP1(1) * $SaTm(2) / $TmP1(2)]
            set lS [expr sqrt($xSm * $xSm + $ySm * $ySm)]
         } 

         set Theta [expr $Theta + 1.0]
      }
      set SgN +
      set Elevation($I) [expr $Theta - 1.0]
   }

   set euvANS(mXBeg) [expr -$Elevation(0)]
   set euvANS(mXEnd) $Elevation(1)
   if { $euvANS(mXBeg) < -44.0 } { set euvANS(mXBeg) -44.0 }
   if { $euvANS(mXEnd) > 44.0 } { set euvANS(mXEnd) 44.0 }
   set euvANS(mYBeg) [expr -$Phase(0)]
   set euvANS(mYEnd) $Phase(1)

   if [string match PT $euvANS(SolGrid)] {
      set gHDM(3) $euvANS(lSLim)
   } else {
      set gHDM(0)  [expr -$euvANS(lSLim)]
      set gHDM(1)  $euvANS(lSLim)
      set gHDM(2)  [expr -$euvANS(lSLim)]
      set gHDM(3)  $euvANS(lSLim)
   }
   set gHDM(4)  [expr int(($gHDM(1) - $gHDM(0)) / $euvANS(xgRes))]
   set gHDM(5)  [expr int(($gHDM(3) - $gHDM(2)) / $euvANS(ygRes))]
}
