package provide EUVSim 1.0

# THIS procedure does some of the post menu setup, setting up various 
#    variables which rely on the final settings of some of the variables
#    which come out of menus.

proc PostMenuSetup { } {
   global euvANS gIMG gHDM gCUT gBIM gMEP 

# FIRST set up all the grid information arrays

# SET up the grid information array for the EUV Image and other variables 
#   which are grided the same way.

   set gBIM(0)  [expr -45.0 + $euvANS(thShift)]
   set gBIM(1)  [expr  45.0 + $euvANS(thShift)]
   set gBIM(2)  -180.0
   set gBIM(3)  180.0
   set gBIM(4)  150
   set gBIM(5)  600
   set gBIM(6)  POINT
   set gBIM(7)  POINT
   set gBIM(8)  COLUMN
   set gBIM(9)  IGNORE
   set gBIM(10) NEW
   set gBIM(11) 0.0
   set gBIM(12) -1.0e31
   set gBIM(13) -1.0e-30
   set gBIM(14) 1.0e30
   set gBIM(15) NO
   set gBIM(16) YES

   set gIMG(0)  $euvANS(mXBeg)
   set gIMG(1)  $euvANS(mXEnd)
   set gIMG(2)  $euvANS(mYBeg)
   set gIMG(3)  $euvANS(mYEnd)
   set gIMG(4)  30
   set gIMG(5)  30
   set gIMG(6)  POINT
   set gIMG(7)  POINT
   set gIMG(8)  COLUMN
   set gIMG(9)  IGNORE
   set gIMG(10) NEW
   set gIMG(11) 0.0
   set gIMG(12) -1.0e31
   set gIMG(13) $euvANS(lowestI)
   set gIMG(14) 1.0e30
   set gIMG(15) NO
   set gIMG(16) NO

# SET up the grid information array for the He Density Matrix

   if { $euvANS(lMax) < 0.0 } { set mX 6.0 } else { set mX $euvANS(lMax) }
   if [string match PT $euvANS(SolGrid)] {
      set gHDM(0)  -3.14159
      set gHDM(1)  3.14159
      set gHDM(2)  1.0
      set gHDM(3)  $mX
      set gHDM(15) YES
   } else {
      set gHDM(0)  [expr -$mX]
      set gHDM(1)  $mX
      set gHDM(2)  [expr -$mX]
      set gHDM(3)  $mX
      set gHDM(15) NO
   }
   set gHDM(4)  [expr int(($gHDM(1) - $gHDM(0)) / $euvANS(xgRes))]
   set gHDM(5)  [expr int(($gHDM(3) - $gHDM(2)) / $euvANS(ygRes))]
   set gHDM(6)  POINT
   set gHDM(7)  POINT
   set gHDM(8)  ROW
   set gHDM(9)  IGNORE
   set gHDM(10) NEW:ADD:END
   set gHDM(11) 0
   set gHDM(12) -5
   set gHDM(13) 0
   set gHDM(14) 1.0e30
   set gHDM(16) NO

# SET up the grid information array for an SM equatoral plot of the measured
#   image

   if { $euvANS(eqDo) == 1 } {
      set gMEP(0)  [expr -double($euvANS(eqMn))]
      set gMEP(1)  [expr double($euvANS(eqMn))]
      set gMEP(2)  [expr -double($euvANS(eqMn))]
      set gMEP(3)  [expr double($euvANS(eqMn))]
      set gMEP(4)  75
      set gMEP(5)  75
      set gMEP(15) NO
   } else {
      set gMEP(0)  -3.14159
      set gMEP(1)  3.14159
      set gMEP(2)  1.0
      set gMEP(3)  $euvANS(eqMn)
      set gMEP(4)  50
      set gMEP(5)  100
      set gMEP(15) YES
   }
   set gMEP(6)  POINT
   set gMEP(7)  POINT
   set gMEP(8)  ROW
   set gMEP(9)  IGNORE
   set gMEP(10) NEW:ADD:END
   set gMEP(11) 0
   set gMEP(12) -5
   set gMEP(13) 0
   set gMEP(14) 1.0e30
   set gMEP(16) NO

   set gCUT(0) 1.0
   set gCUT(1) [expr abs($euvANS(psMn))]
   set gCUT(2) -1.0
   set gCUT(3) 1.0
   set gCUT(4) 100
   set gCUT(5) 1
   set gCUT(6) POINT
   set gCUT(7) POINT
   set gCUT(8) COLUMN
   set gCUT(9) KEEP
   set gCUT(10) NEW:ADD:END
   set gCUT(11) 1.0e-20
   set gCUT(12) 1.0e-20
   set gCUT(13) 0.0
   set gCUT(14) 1.0e30
   set gCUT(15) NO
   set gCUT(16) NO

#  NOW determine the number of plots based on the solution matrix that
#     are to be output and compute the number of plots per page from
#     this

   set shortList [list rm sm ]
   set PLen [llength $shortList]
   for { set I 0 } { $I < $PLen } { incr I } {
      set pID [lindex $shortList $I]
      if { $euvANS(${pID}Do) > 0 } {

         set BeG $euvANS(${pID}Bg)
         if { $BeG < 0 } { set BeG [expr $euvANS(nIter) - 1] }
         set EnD $euvANS(${pID}Ed)
         if { ($EnD < 0) || ($EnD >= $euvANS(nIter)) } { 
            set EnD [expr $euvANS(nIter) - 1]
         }

         set nPlots [expr $EnD - $BeG + 1]
         if {[expr $nPlots % $euvANS(${pID}Dt)] > 0 } { 
            set Extra 1 
         } else { set Extra 0 }

         set euvANS(${pID}Np) [expr int($nPlots / $euvANS(${pID}Dt)) + $Extra]
      } 
   }

#  See if we really need to run the full simulation.

   set euvANS(NeedSim) 0 
   set euvANS(NeedLoS) 0 
   if $euvANS(doPrnt) {
       set euvANS(NeedSim) 1 
   } else { 
      set dPLen [llength $euvANS(PiD)]
      for { set I 0 } { $I < $dPLen } { incr I } {
         set pID [lindex $euvANS(PiD) $I]
         if { $euvANS(${pID}Do) > 0 } {
            if { [string compare $pID eq] == 0 } { 
               set euvANS(NeedLoS) 1 
            } elseif { [string compare $pID mi] != 0 } { 
               set euvANS(NeedSim) 1 
               set euvANS(NeedLoS) 1 
               break
            }
         }
      }
   }
}
