#  THIS performs some of the initial setup for establishing the windows and
#    such that the plots will be drawn in.  The procedure DynamicPlots does
#    most of the scaling and sizing since many of the plots are dynamic in
#    their extent

package provide EUVSim 1.0

proc PlotSetUp { } {
   global euvANS pPg

# DETERMINE how many pages of plots we are producing and how many plots are
#   to be output on each page.

   set euvANS(AnyNonPS) 0 
   set euvANS(TotP) 0 
   set PLen [llength $euvANS(PiD)]
   set euvANS(pPgs) ""
   for { set I 0 } { $I < $PLen } { incr I } {
      set pID [lindex $euvANS(PiD) $I]
      if { $euvANS(${pID}Do) > 0 } { 
         incr euvANS(TotP)
         if { $euvANS(${pID}PScript) == 0 } { set euvANS(AnyNonPS) 1 } 
         set PgN $euvANS(${pID}Pg)
         if [info exists euvANS(${pID}Np)] {
            set IncV $euvANS(${pID}Np)
         } else { set IncV 1 }

         if ![info exists pPg($PgN)] { 
             set pPg($PgN) $IncV 
             lappend euvANS(pPgs) $PgN
         } else { incr pPg($PgN) $IncV } 
      }
   }
}
