package provide EUVSim 1.0

# THIS procedure produces the plots of all the meshes

proc PlotResults { } {
   global GphInfo euvANS Yr Dy Msec \
          miImG siImG raImG lsImG psImG agImG rgImG eqImG

   PlotStep PLOTTING

   set Time [TUtimeFmt 0 $Yr(0) $Dy(0) $Msec(0)]
   set euvANS(miT1) $Time
   set euvANS(miT2) "Kp : $euvANS(kP)"
   set euvANS(siT1) "Iterations: $euvANS(nIter)"
   set euvANS(siT2) "Standard Deviation: [format "%.2f" $euvANS(Var)]"
   set euvANS(psT1) $Time
   set euvANS(rgT1) $Time
   set euvANS(agT1) $Time
   set euvANS(psT2) "Kp : $euvANS(kP)"

   set TmP $euvANS(miDec)
   set euvANS(miDec) 1

   for { set I 0 } { $I < 8 } { incr I } {
      set pID [lindex $euvANS(PiD) $I]
      if { $euvANS(${pID}Do) > 0 } {
         MassageGrid ${pID}ImG oGrid oNorM oGInfo $pID
         PutUpPlot $pID oGrid oGInfo
      }
   }

   set euvANS(miDec) $TmP

   if { $euvANS(rcDo) > 0 } { RadialPlotCuts rc }
}
