# first we load in the standard vtk packages into tcl

package require vtk
package require vtkinteraction
package require vtktesting

# MAKE sure that all of the sources are identified to the program
 
source [ file join $env(TCLTOOLS_HOME) TclToolInits.tcl ]
TclToolInits GPH GUI PLT UTILS

lappend auto_path [file join $env(TCLTOOLS_HOME) TclEUVSim]
package require EUVSim
package require EUVSim_C


GraphicsOn VTK ETones
#colorLUT SetTableRange 0.0 3.6

#vtkFloatArray X
#   for { set C 0 } { $C < 22  } { incr C } {
#      set xV [expr $C * 20 ]
#      X InsertNextValue $xV
#   }

#vtkFloatArray Y
#   for { set R 0 } { $R < 22 } { incr R } {
#      set yV [expr $R * 20]
#      Y InsertNextValue $yV
#   }

# vtkFloatArray Z
#   for { set R 0 } { $R < 22 } { incr R } {
#      set zV [expr 0.1 * ($R - 10)]
#      Z InsertNextValue $zV
#   }

#vtkFloatArray Z
#   Z InsertNextValue 0.0
  
vtkFloatArray D
   D SetNumberOfValues 1
#  D SetNumberOfTuples [expr 21 * 21 * 21]
   D SetNumberOfTuples [expr 21 * 21]
   set N  0
#  for {set K 0} {$K < 21} {incr K} {
#     set zV [expr 0.1 * ($K - 10) + .05]
      for {set J 0} {$J < 21} {incr J} {
         set yV [expr 0.1 * ($J - 10) + .05]
         for {set I 0} {$I < 21} {incr I} {
            set xV [expr 0.1 * ($I - 10) + .05]
#           set s [expr sqrt($xV*$xV + $yV*$yV + $zV * $zV)]
            set s [expr sqrt($xV*$xV + $yV*$yV)]
            D SetTuple1 $N $s
#           D InsertNextValue $s
            incr N
         }
      }
#  }

# CREATE a 100 by 100 point plane to sample 
 
vtkImageData rGriD
# rGriD SetDimensions 21 21 21
  rGriD SetDimensions 21 21 1
  [rGriD GetPointData] SetScalars D

vtkImageDataGeometryFilter geom1
  geom1 SetInput rGriD
  geom1 SetExtent 0 22 0 22 0 0

 vtkWarpScalar gWarp
     gWarp SetInput [geom1 GetOutput]
     gWarp SetScaleFactor 10.0

 vtkPolyDataMapper geom1Mapper
    geom1Mapper SetInput [gWarp GetOutput ]
    geom1Mapper SetLookupTable colorLUT

#   geom1Mapper SetScalarRange 0.6  1.6
                                                                                
vtkActor gActor
   gActor SetMapper geom1Mapper
                                                                                
# Create the RenderWindow, Renderer

  vtkRenderer ren1
  vtkRenderWindow renWin
      renWin AddRenderer ren1
  vtkRenderWindowInteractor iren
      iren SetRenderWindow renWin
 
  ren1 AddActor gActor
  renWin SetSize 500 500

# render the image
#
  iren AddObserver UserEvent {wm deiconify .vtkInteract}
# [ren1 GetActiveCamera] Zoom 1.5
  renWin Render

# prevent the tk window from showing up then start the event loop
 wm withdraw .

