package provide EUVSim 1.0

proc MassageGrid { iGrid oGrid oNorM oGInfo PiD } {
   global euvANS  gHDM gIMG gMEP

   upvar $iGrid  iG
   upvar $oGrid  oG
   upvar $oNorM  oN
   upvar $oGInfo oGI

   set dcim $euvANS(${PiD}Dec)
   set sm   $euvANS(${PiD}Sm)

# DUPLICATE the grid information array

   switch -exact -- $PiD {
       si -
       mi -
       ls -
       ra  { 
          set nE [array size gIMG]
          for { set I 0 } { $I < $nE} { incr I } { set iGI($I) $gIMG($I) }
       }
       rm -
       sm -
       zm -
       ps  {
          set nE [array size gHDM]
          for { set I 0 } { $I < $nE} { incr I } { set iGI($I) $gHDM($I) }
       }
       eq  {
          set nE [array size gMEP]
          for { set I 0 } { $I < $nE} { incr I } { set iGI($I) $gMEP($I) }
       }
       rg -
       ag  {
          set nE [array size gHDM]
          for { set I 0 } { $I < $nE} { incr I } { set iGI($I) $gHDM($I) }
          set iGI(12) -1.0e30
          set iGI(13) -1.0e29
       }
   }

   for { set I 0 } { $I < $nE} { incr I } { set oGI($I) $iGI($I) }

# DECIMATE before SMOOTH

   if { $dcim > 1 } {
      set oGI(4) [expr int($oGI(4) / $dcim)]
      set oGI(5) [expr int($oGI(5) / $dcim)]
      TUgridReGrid REGRID iG iGI oG oGI oN END
      if { [string match mi $PiD] && ($euvANS(pcdeSpeck) == 1) } {
         for { set I 0 } { $I < $euvANS(pcspRep) } { incr I } {
            TUgridNoise DESPECKLE oG oGI $euvANS(pcspeckN) $euvANS(pcspMin) 0.0
         }
      }
   } else { TUgridMath iG DUP iG oG iGI }


# SMOOTH it

   if [string match NO $sm] { return }

   set fE ""
   switch -exact -- $sm {
      3x3L {
         set fE [list 1.0  2.0  1.0 \
                      2.0  4.0  2.0 \
                      1.0  2.0  1.0 ]
      }
      3x3H {
         set fE [list -1.0  -1.0  -1.0 \
                      -1.0   9.0  -1.0 \
                      -1.0  -1.0  -1.0 ]
      }
      5x5L {
         set fE [list 1.0  1.0   1.0  1.0  1.0 \
                      1.0  4.0   4.0  4.0  1.0 \
                      1.0  4.0  12.0  4.0  1.0 \
                      1.0  4.0   4.0  4.0  1.0 \
                      1.0  1.0   1.0  1.0  1.0 ]
      }
      5x5H {
         set fE [list  0.0  -1.0   -1.0  -1.0   0.0 \
                      -1.0   2.0   -4.0   2.0  -1.0 \
                      -1.0  -4.0   13.0  -4.0  -1.0 \
                      -1.0   2.0   -4.0   2.0  -1.0 \
                       0.0  -1.0   -1.0  -1.0   0.0 ]
      }
   }

# NORMALIZE the smoothing mask

   set SuM 0.0
   set nE [llength $fE]
   for { set I 0 } { $I < $nE } { incr I } { 
      set F($I) [lindex $fE $I] 
      set SuM [expr $SuM + abs($F($I))] 
   }
   for { set I 0 } { $I < $nE } { incr I } { 
      set F($I) [expr $F($I) / $SuM] 
   }

# Smooth the grid

   set sOp(0) 0
   TUgridFilter 2DFILTER oG oGI sOp F
}
