package provide EUVSim 1.0

proc MaskOut { } {
   global euvANS miImG gIMG

   TUgridInfo 32 gIMG xC
   TUgridInfo 33 gIMG yC

   set Zones  [list Top Bot Left Right]
   set IndeX  [list 0 0 1 1]
   set ZoneID [list 0 1 2 3]

   for { set K 0 } { $K < 4 } { incr K } {
      set iD  [lindex $Zones $K] 
      set iDx [lindex $IndeX $K] 
      set zID [lindex $ZoneID $K] 
      set Val ""
      for { set I 0 } { $I < 10 } { incr I } {
         set xL [string length $euvANS(${iD}X$I)]
         set yL [string length $euvANS(${iD}Y$I)]
         if { ($xL > 0) && ($yL > 0) } { 
	    lappend Val [list $euvANS(${iD}X$I) $euvANS(${iD}Y$I)]
	 }
      }

      set nE [llength $Val]
      if { $nE < 2 } { continue }

      set sVal [lsort -real -increasing -index $iDx $Val]
      set nE [llength $sVal]
      for { set I 0 } { $I < $nE } { incr I } {
         set X($I) [lindex [lindex $sVal $I] 0]
         set Y($I) [lindex [lindex $sVal $I] 1]
      }

      set xL $X(0) ; set yL $Y(0)
      set xU $X(1) ; set yU $Y(1)
      set cU 2

      incr nE -1
      if { $iDx == 0 } {
         set A [expr ($yU - $yL) / ($xU - $xL) ]
         set B [expr $yL - $A * $xL]

         for { set I 0 } { $I < $gIMG(4) } { incr I } {
            while { ($xC($I) > $xU) && ($cU < $nE) } {  
	       set xL $xU ; set xU $X($cU)
	       set yL $yU ; set yU $Y($cU)
               set A [expr ($yU - $yL) / ($xU - $xL) ]
               set B [expr $yL - $A * $xL]
	       incr cU
	    }
	    set yV [expr $A * $xC($I) + $B]
            TUgridInfo 0 gIMG PoS $xC($I) $yV

            if { $zID == 0 } {
               for { set J $PoS(2) } { $J < $gIMG(5) } { incr J } {
                  TUgridInfo 1 gIMG rV $PoS(1) $J
                  if { $rV(0) >= 0 } { set miImG($rV(0)) 0.0 }
               } 
            } else {
               for { set J $PoS(2) } { $J >= 0 } { incr J -1 } {
                  TUgridInfo 1 gIMG rV $PoS(1) $J
                  if { $rV(0) >= 0 } { set miImG($rV(0)) 0.0 }
               } 
	    }
         }
      } else {
         set A [expr ($xU - $xL) / ($yU - $yL) ]
         set B [expr $xL - $A * $yL]

         for { set I 0 } { $I < $gIMG(5) } { incr I } {
            while { ($yC($I) > $yU) && ($cU < $nE) } {  
	       set xL $xU ; set xU $X($cU)
	       set yL $yU ; set yU $Y($cU)
               set A [expr ($xU - $xL) / ($yU - $yL) ]
               set B [expr $xL - $A * $yL]
	       incr cU
	    }
	    set xV [expr $A * $yC($I) + $B]
            TUgridInfo 0 gIMG PoS $xV $yC($I)

            if { $zID == 3 } {
               for { set J $PoS(1) } { $J < $gIMG(4) } { incr J } {
                  TUgridInfo 1 gIMG rV $J $PoS(2)
                  if { $rV(0) >= 0 } { set miImG($rV(0)) 0.0 }
               } 
            } else {
               for { set J $PoS(1) } { $J >= 0 } { incr J -1 } {
                  TUgridInfo 1 gIMG rV $J $PoS(2)
                  if { $rV(0) >= 0 } { set miImG($rV(0)) 0.0 }
               } 
            }
         }
      }
   }
}
