package provide EUVSim 1.0

proc Iterate { nG lDen } {
   global CurInfo cDm pStat gHDM LoSBeG LoSEnD

   upvar $lDen V

# SET the Current Information which is used by the procedure which computes
#   the density as a function of R

   set CurInfo(2) $gHDM(0)
   set CurInfo(3) $gHDM(2)
   set CurInfo(4) [expr abs(($gHDM(1) - $gHDM(0))) / $gHDM(4)]
   set CurInfo(5) [expr abs(($gHDM(3) - $gHDM(2))) / $gHDM(5)]
   set CurInfo(6) $gHDM(4)
   set CurInfo(7) $gHDM(5)

# LOOP over all of the grid values (line of sights)

   set CnT 0
   set Var 0.0
   for { set I 0 } { $I < $nG } { incr I } {
      set CurInfo(0) $I
      if { $pStat($I) <= 0 } { continue }
      if { $cDm($I) > 0.0 } {
         set cDi [ColDen Func2D $LoSBeG($I) $LoSEnD($I) 1]
         if { $cDi > 0.0 } {
            set V($CnT) [expr $V($CnT) * $cDm($I) / $cDi]
            set dF [expr ($cDm($I) - $cDi) / $cDm($I) ]
            set Var [expr $Var + $dF * $dF]
         } else { set V($CnT) 0.0 }
      } else { set V($CnT) 0.0 }
      incr CnT
   }

   if { $CnT > 0 } {
       set Var [expr sqrt ($Var / double($CnT))]
   } else { set Var -1.0 }

   return $Var 
}
