package provide EUVSim 1.0

# THIS procedure tries to optimize the inputs to TUgridFill2D so that there
#    the smoothing does not have too much trouble near the edges.

proc GridFillInputs { Grid Norm gInFo sInFo } {
   global euvANS 

# SET up the array variables.  

   upvar $Grid  G
   upvar $Norm  N
   upvar $gInFo gI
   upvar $sInFo sI

   set oP(0) 0.0
   set oP(1) 1
   set rV [TUgridTrim EDGES G N gI oP]

   if [string match PT $euvANS(SolGrid)] {
      set sI(4) 0
      set sI(5) 0
   } else {
      set sI(4) [lindex $rV 0]
      set sI(5) [lindex $rV 1]
   }
   set sI(6) [lindex $rV 2]
   set sI(7) [lindex $rV 3]

   set sI(0) 1
  
# DETERMINE how far to search from the unfilled mesh for known data. 
#    This is just a guess.  First determine how many points known
#    grids have assigned values.

  set tP 0
  set tG [expr $gI(4) * $gI(5)]
  for { set I 0 } { $I < $tG } { incr I } { 
      if { $N($I) > 0.0 } { incr tP } 
  }

#  THIS is the number of grids.

   set nG [expr ($gI(4) - $sI(5) - $sI(4)) * ($gI(5) - $sI(7) - $sI(6))]

# IF they are evenly spread out then the number of grids to look out from
#    the unknown grid is probably where the 3 is slop.

   if { $tP == 0 } { set tP $nG } 
   set sI(1) [expr int ($nG / $tP) + 3]

# THE rest of the smoothing information can just be filled in now.

   set sI(2) 4
   set sI(3) 0
   set sI(4) 0
   set sI(5) 0
   set sI(8) 2.0
}
