# first we load in the standard vtk packages into tcl

package require vtk
package require vtkinteraction
package require vtktesting

# MAKE sure that all of the sources are identified to the program
 
source [ file join $env(TCLTOOLS_HOME) TclToolInits.tcl ]
TclToolInits GPH GUI PLT UTILS

lappend auto_path [file join $env(TCLTOOLS_HOME) TclEUVSim]
package require EUVSim
package require EUVSim_C

if { $argc < 2 } { 
   puts stderr "NEED BOTH EUV AND ION DATA FILES"
   exit
} 

set EUVfile [lindex $argv 0] 
set Yr [string range $EUVfile 0 3] 
set Day [string range $EUVfile 4 6] 
set Hr [string range $EUVfile 7 8] 
set Mn [string range $EUVfile 9 10] 
set Ss [string range $EUVfile 11 12] 

set DoPnG 0
set NoFiles 1
if { $argc == 4 } { 
   set ExT [lindex $argv 3]
   set DoPnG 1
   set NoFiles 2
} else {
   if { $argc == 3 } { 
      set FirstC [string range [lindex $argv 2] 0 0] 
      if { ($FirstC == "M") || ($FirstC == "H") } {
         set NoFiles 2
      } else { set ExT [lindex $argv 2] ; set DoPnG 1 }
   } 
}

set I 1
for { set nIons 0 } { $nIons < $NoFiles } { incr nIons ; incr I } {
   set  IONfile($nIons) [lindex $argv $I]
   set  ExP($nIons) [lindex [split $argv '-'] 0]
   set  lEr($nIons) [lindex [split $argv '-'] 1]
   set  uEr($nIons) [lindex [split $argv '-'] 2]
}

vtkMath math

 GraphicsOn VTK RainBow
 colorLUT SetNumberOfTableValues 254

set nP [ReadEUVInv $EUVfile X Y D gI]
set gI(10) NEW:ADD:END
set gI(4) 100
set gI(5) 100
set gI(0) [expr -$gI(3)]
set gI(1) $gI(3)
set gI(2) [expr -$gI(3)]
set g(15) NO
set g(15) NO

for { set I 0 } { $I < $nP } { incr I } {
  set Gx($I) [expr $Y($I) * cos($X($I))]
  set Gy($I) [expr $Y($I) * sin($X($I))]
}
 
set sI(0) 1 ; set sI(1) 5 ; set sI(2) 4
set sI(3) 2 ; set sI(4) 1 ; set sI(5) 0
set sI(6) 0 ; set sI(7) 0 ; set sI(8) -2

set sOp 0

TUdataGrid $nP 1 Gx Gx 1 Gy Gy D GriD gNorM gI
TUgridFill2D GriD gI "" sI
set F(0) 1.  ; set F(1) 1.  ; set F(2) 1.   ; set F(3) 1.  ; set F(4) 1.
set F(5) 1.  ; set F(6) 4.  ; set F(7) 4.   ; set F(8) 4.  ; set F(9) 1.
set F(10) 1. ; set F(11) 4. ; set F(12) 12. ; set F(13) 4. ; set F(14) 1.
set F(15) 1. ; set F(16) 4. ; set F(17) 4.  ; set F(18) 4. ; set F(19) 1.
set F(20) 1. ; set F(21) 1. ; set F(22) 1.  ; set F(23) 1. ; set F(24) 1.
                                                                                
set SuM 0.0
for { set I 0 } { $I < 25 } { incr I } { set SuM [expr $SuM + $F($I)] }
for { set I 0 } { $I < 25 } { incr I } { set F($I) [expr $F($I) / $SuM] }
                                                                                
TUgridFilter 2DFILTER GriD gI sOp F

set I  0
vtkFloatArray xV
  xV SetNumberOfTuples $gI(4)
  xV SetNumberOfComponents 1
   for { set C 0 } { $C < $gI(4) } { incr C } {
      TUgridInfo 1 gI rV $C 0
      TUgridInfo 20 gI rI $rV(0)
      xV SetTuple1 $C $rI(2)
   }

vtkFloatArray yV
  yV SetNumberOfTuples $gI(5)
  yV SetNumberOfComponents 1
   for { set R 0 } { $R < $gI(5) } { incr R } {
      TUgridInfo 1 gI rV 0 $R
      TUgridInfo 20 gI rI $rV(0)
      yV SetTuple1 $R $rI(3)
   }

vtkFloatArray zV
  zV SetNumberOfTuples 2
  zV SetNumberOfComponents 1
  zV SetTuple1 0 0.0
  zV SetTuple1 1 1.0
                                                                                
vtkFloatArray dV
   set N [expr $gI(4) * $gI(5)]
   dV SetNumberOfValues 1
   dV SetNumberOfTuples [expr 2 * $gI(4) * $gI(5)]
   for { set C 0 } { $C < $gI(4) } { incr C } {
      for { set R 0 } { $R < $gI(5) } { incr R } {
         TUgridInfo 1 gI rV $C $R
         if { $GriD($rV(0)) > 0.0 } {
            dV SetTuple1 $N [expr log10($GriD($rV(0)))]
         } else { dV SetTuple1 $N -1.0 }
         incr N
      }
   }

set gI(10) NEW
set gI(15) NO
set gI(16) NO
TUdataGrid $nP 1 X X 1 Y Y D GriD gNorM gI
set gI(10) ADD
for { set I 0 } { $I < $nIons } { incr I } {
   set nP [ReadIonInv $IONfile($I) X Y D ]
   TUdataGrid $nP 1 X X 1 Y Y D GriD gNorM gI
}

set gI(10) END
TUdataGrid $nP 1 X X 1 Y Y D GriD gNorM gI
TUgridFill2D GriD gI "" sI
TUgridMath GriD GRADCY aGraD rGraD gI

set tP [expr $gI(4) * $gI(5)]
set InDx [TUdataMxMn rGraD $tP <>]
set MinV $rGraD([lindex $InDx 0])
set MaxV $rGraD([lindex $InDx 1])

set N 0
for { set C 0 } { $C < $gI(4) } { incr C } {
   for { set R 0 } { $R < $gI(5) } { incr R } {
      TUgridInfo 1 gI rV $C $R
      dV SetTuple1 $N $rGraD($rV(0))
      incr N
   }
}

# CREATE a 100 by 100 point plane to sample 
 
vtkRectilinearGrid rGriD
  rGriD SetDimensions $gI(4) $gI(5) 2
  rGriD SetXCoordinates xV
  rGriD SetYCoordinates yV
  rGriD SetZCoordinates zV
  [rGriD GetPointData] SetScalars dV
                                                      
vtkRectilinearGridGeometryFilter pplane
  pplane SetInput rGriD
  pplane SetExtent 0  99  0  99  1  1

vtkRectilinearGridGeometryFilter iplane
  iplane SetInput rGriD
  iplane SetExtent 0  99  0  99  0  0

vtkTransform rZ
  rZ RotateZ 270.0

vtkTransformPolyDataFilter itF
  itF SetInput [iplane GetOutput]
  itF SetTransform rZ

vtkTransformPolyDataFilter ptF
  ptF SetInput [iplane GetOutput]
  ptF SetTransform rZ
  
 vtkContourFilter cf
   cf SetInput [itF GetOutput]
   cf GenerateValues 40 $MinV $MaxV
# cf GenerateValues 40 3.0 6.7

# Create the mapper and actor for the structrued grid

vtkPolyDataMapper pMapper
  pMapper SetLookupTable colorLUT
  pMapper SetScalarRange $MinV $MaxV
# pMapper SetScalarRange 0.0 3.3
  pMapper SetInput [ptF GetOutput]

vtkPolyDataMapper iMapper
  iMapper SetLookupTable colorLUT
  iMapper SetScalarRange $MinV $MaxV
# iMapper SetScalarRange 3.0 6.7
  iMapper SetInput [cf GetOutput]

vtkActor pActor
  pActor SetMapper pMapper

 vtkActor iActor
   iActor SetMapper iMapper

# Create a scalar bar

vtkTextProperty cBtProp
   cBtProp SetFontSize 16
   cBtProp BoldOn

vtkScalarBarActor pCB
    pCB SetLookupTable [pMapper GetLookupTable]
    pCB SetTitle "Log NHe+"
    [pCB GetPositionCoordinate] SetCoordinateSystemToNormalizedViewport
    [pCB GetPositionCoordinate] SetValue 0.2  0.12
    pCB SetOrientationToHorizontal
    pCB SetNumberOfLabels 4
    pCB SetWidth 0.60
    pCB SetHeight 0.10
    pCB SetTitleTextProperty cBtProp
    pCB SetLabelTextProperty cBtProp
                                                                                
vtkScalarBarActor iCB
   iCB SetLookupTable [iMapper GetLookupTable]
   iCB SetTitle "Log Ion Flux"
   [iCB GetPositionCoordinate] SetCoordinateSystemToNormalizedViewport
   [iCB GetPositionCoordinate] SetValue 0.2  0.01
   iCB SetOrientationToHorizontal
   iCB SetNumberOfLabels 4
   iCB SetWidth 0.60
   iCB SetHeight 0.10
   iCB SetTitleTextProperty cBtProp
   iCB SetLabelTextProperty cBtProp

vtkTextProperty tProp
   tProp SetFontSize 24
   tProp BoldOn
   tProp SetJustificationToCentered

vtkTextMapper tMapper
   set tprop [tMapper GetTextProperty]
   $tprop ShallowCopy tProp
   tMapper SetInput "EUV/$ExP(0)\n$Yr $Day $Hr:$Mn:$Ss\nIons $lEr(0)-$uEr(0) keV"

vtkActor2D tActor
   tActor SetMapper tMapper
   [tActor GetPositionCoordinate] SetCoordinateSystemToNormalizedViewport
   [tActor GetPositionCoordinate] SetValue .5 .85

 
# Create the RenderWindow, Renderer
 
vtkRenderer ren1
vtkRenderWindow renWin
    renWin AddRenderer ren1

vtkRenderWindowInteractor iren
    iren SetRenderWindow renWin

ren1 AddActor pActor
ren1 AddActor2D pCB
#ren1 AddActor iActor
ren1 AddActor2D iCB
ren1 AddActor tActor
renWin SetSize 700 700

ren1 SetBackground 0 0 0
[ren1 GetActiveCamera] Zoom 0.9
[ren1 GetActiveCamera] Elevation 180.0

renWin Render

if { $DoPnG } {
  vtkWindowToImageFilter w2if
  w2if SetInput renWin

  vtkPNGWriter wr
  wr SetInput [w2if GetOutput]
  wr SetFileName "EUVION_$ExT.png"
  wr Write
  vtkCommand DeleteAllObjects
  exit
} else {
                                                                                
# render the image
#
  iren AddObserver UserEvent {wm deiconify .vtkInteract}

# prevent the tk window from showing up then start the event loop
  wm withdraw .
}
