#THIS procedure initializes the He solution matrix

package provide EUVSim 1.0

proc FirstGuess { nP xV yV Den } {
   global euvANS CurInfo SaTm pStat lsImG gMl cDm xSM ySM

   upvar $xV  X 
   upvar $yV  Y 
   upvar $Den D 

# SET the XY grid positions separately since how they are set depends
#   on  the type of solution grid we are using.

   set CnT 0

   if [string match XY $euvANS(SolGrid)] {
      for { set I 0 } { $I < $nP } { incr I } {
         if { $pStat($I) > 0 } { 
            set X($CnT) $xSM($I)
            set Y($CnT) $ySM($I)
            incr CnT
         }
      }
   } else {
      for { set I 0 } { $I < $nP } { incr I } {
         if { $pStat($I) > 0 } {
            set X($CnT) $gMl($I)
            set Y($CnT) $lsImG($I)
            incr CnT
         }
      }
   }


# SET the maximum LShell to process to 100.   Kind of large but hey, we
#   are only initalizing the matrix not really expecting a solution here.

   set CurInfo(1) 100.0

# SET up the coefficients that will be used to estimate a He density.
#   This estimation is constant both along L and longitude.  It only
#   depends on L.  The formula is
#
#             D = 10^(-.715*L) or log(D) = -.715 * L 

   set B(0) 0.0
   set B(1) -0.715

#  GET the distance of the satellite from the Earth.  The initial line
#   of sight integrals are carried out to twice that distance starting
#   at the satellite.

   set sPos [TUvecMath SaTm MAG SaTm SaTm]
   set EndI [expr 2.0 * $sPos]

# LOOP over each of the lines of sight

   set CnT 0
   for { set I 0 } { $I < $nP } { incr I } {

# IF we should not be considering this line of sight then continue.  This
#   would be true if for example the line of sight hit the Earth.

      if { $pStat($I) <= 0 } { continue }

# IF the column density along this line of sight is 0 then set the solution
#    matrix representing the line of sight to 0 
#
# OTHERWISE produce column integrals along the line of sights using the
#    default density determination given above.  The density put into
#    solution matrix is the estimated density at the minimum L-Shell
#    multiplied by the ratio of the measured to simulated column densities.

      if { $cDm($I)  == 0.0 } {
         set cDi 0.0
         set D($CnT) 0.0
      } else {
         set CurInfo(0) $I
         set cDi [ColDen Func1D 0.0 $EndI 1 ]
         set Density [expr pow(10.0, [TUpolyExp1D $lsImG($I) 2 B 0 100 -100])]
         set D($CnT) [expr ($cDm($I) * $Density) / $cDi]
      } 
      incr CnT
   }

   return $CnT
}
